/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.StreamsTaskMetadata;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConstants;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.LagInfo;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;

public interface QueryMetadata {
    public void initialize();

    public Set<StreamsTaskMetadata> getTaskMetadata();

    public Map<String, Object> getOverriddenProperties();

    public String getStatementString();

    public void setUncaughtExceptionHandler(StreamsUncaughtExceptionHandler var1);

    public KafkaStreams.State getState();

    public KsqlConstants.KsqlQueryStatus getQueryStatus();

    public String getExecutionPlan();

    public String getQueryApplicationId();

    public Topology getTopology();

    public Map<String, Map<Integer, LagInfo>> getAllLocalStorePartitionLags();

    public Collection<StreamsMetadata> getAllStreamsHostMetadata();

    public Map<String, Object> getStreamsProperties();

    public LogicalSchema getLogicalSchema();

    public Set<SourceName> getSourceNames();

    public boolean hasEverBeenStarted();

    public QueryId getQueryId();

    public KsqlConstants.KsqlQueryType getQueryType();

    public String getTopologyDescription();

    public List<QueryError> getQueryErrors();

    public void setCorruptionQueryError();

    public KafkaStreams getKafkaStreams();

    public void pause();

    public void resume();

    public void close();

    public void start();

    public static interface Listener {
        public void onError(QueryMetadata var1, QueryError var2);

        public void onStateChange(QueryMetadata var1, KafkaStreams.State var2, KafkaStreams.State var3);

        public void onPause(QueryMetadata var1);

        public void onResume(QueryMetadata var1);

        public void onClose(QueryMetadata var1);
    }

    public static interface RetryEvent {
        public long nextRestartTimeMs();

        public int getNumRetries(String var1);

        public void backOff(String var1);
    }
}

