/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.query.KafkaStreamsBuilder;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.QueryMetadataImpl;
import io.confluent.ksql.util.SharedKafkaStreamsRuntime;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandboxedSharedKafkaStreamsRuntimeImpl
extends SharedKafkaStreamsRuntime {
    private final Logger log = LoggerFactory.getLogger(SandboxedSharedKafkaStreamsRuntimeImpl.class);

    public SandboxedSharedKafkaStreamsRuntimeImpl(SharedKafkaStreamsRuntime sharedRuntime) {
        super(sharedRuntime.getKafkaStreamsBuilder(), SandboxedSharedKafkaStreamsRuntimeImpl.getSandboxStreamsProperties(sharedRuntime));
        Collection namedTopologies = this.collocatedQueries.values().stream().map(BinPackedPersistentQueryMetadataImpl::getTopology).collect(Collectors.toSet());
        if (!namedTopologies.containsAll(sharedRuntime.kafkaStreams.getAllTopologies()) || !sharedRuntime.kafkaStreams.getAllTopologies().containsAll(namedTopologies)) {
            this.log.warn("Streams topologies and registered queries do not align. \nmetadata: {} \nstreams: {}", namedTopologies.stream().map(s -> s.name()).collect(Collectors.toList()), sharedRuntime.kafkaStreams.getAllTopologies().stream().map(s -> s.name()).collect(Collectors.toList()));
        }
        this.collocatedQueries.putAll(sharedRuntime.collocatedQueries);
        for (BinPackedPersistentQueryMetadataImpl query : sharedRuntime.collocatedQueries.values()) {
            this.kafkaStreams.addNamedTopology(query.getTopologyCopy(this));
        }
    }

    public SandboxedSharedKafkaStreamsRuntimeImpl(KafkaStreamsBuilder kafkaStreamsBuilder, Map<String, Object> streamsProperties) {
        super(kafkaStreamsBuilder, streamsProperties);
    }

    private static Map<String, Object> getSandboxStreamsProperties(SharedKafkaStreamsRuntime sharedKafkaStreamsRuntime) {
        ConcurrentHashMap<String, Object> sandboxStreamsProperties = new ConcurrentHashMap<String, Object>(sharedKafkaStreamsRuntime.getStreamProperties());
        sandboxStreamsProperties.put("application.id", sharedKafkaStreamsRuntime.getStreamProperties().get("application.id") + "-validation");
        return sandboxStreamsProperties;
    }

    @Override
    public void register(BinPackedPersistentQueryMetadataImpl binpackedPersistentQueryMetadata) {
        QueryId queryId = binpackedPersistentQueryMetadata.getQueryId();
        this.log.info("Registering query {} for validation for runtime {}", (Object)queryId, (Object)this.getApplicationId());
        this.collocatedQueries.put(queryId, binpackedPersistentQueryMetadata);
        try {
            if (this.kafkaStreams.getTopologyByName(queryId.toString()).isPresent()) {
                this.kafkaStreams.removeNamedTopology(queryId.toString(), false).all().get();
            }
            this.kafkaStreams.addNamedTopology(binpackedPersistentQueryMetadata.getTopologyCopy(this)).all().get();
        }
        catch (Throwable e) {
            Throwable t = e instanceof ExecutionException && e.getCause() != null ? e.getCause() : e;
            throw new IllegalStateException(String.format("Encountered an error when trying to add query %s to runtime: %s", queryId, this.getApplicationId()), t);
        }
        this.log.info("Registered query: {}  in {} \nRuntime {} is executing these queries: {}", new Object[]{queryId, this.getApplicationId(), this.getApplicationId(), this.collocatedQueries.keySet().stream().map(QueryId::toString).collect(Collectors.joining(", "))});
    }

    @Override
    public void stop(QueryId queryId, boolean resetOffsets) {
    }

    @Override
    public QueryMetadataImpl.TimeBoundedQueue getNewQueryErrorQueue() {
        return new QueryMetadataImpl.TimeBoundedQueue(Duration.ofHours(1L), 0);
    }

    @Override
    public synchronized void close() {
        this.log.info("Closing validation runtime {}", (Object)this.getApplicationId());
        this.kafkaStreams.close();
        this.kafkaStreams.cleanUp();
    }

    @Override
    public void start(QueryId queryId) {
    }

    @Override
    public void overrideStreamsProperties(Map<String, Object> newStreamsProperties) {
    }

    @Override
    public void restartStreamsRuntime() {
    }
}

