/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.authorizer.Scope;
import java.util.Objects;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class RoleBindingKey
extends AuthKey {
    private final KafkaPrincipal principal;
    private final String role;
    private final Scope scope;

    @JsonCreator
    public RoleBindingKey(@JsonProperty(value="principal") KafkaPrincipal principal, @JsonProperty(value="role") String role, @JsonProperty(value="scope") Scope scope) {
        this.principal = principal;
        this.role = role;
        this.scope = scope;
    }

    @JsonProperty
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @JsonProperty
    public String role() {
        return this.role;
    }

    @JsonProperty
    public Scope scope() {
        return this.scope;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.ROLE_BINDING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleBindingKey)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBindingKey that = (RoleBindingKey)o;
        return Objects.equals(this.principal, that.principal) && Objects.equals(this.role, that.role) && Objects.equals(this.scope, that.scope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.principal, this.role, this.scope);
    }

    public String toString() {
        return "RoleBindingKey{principal=" + this.principal + ", role='" + this.role + '\'' + ", scope='" + this.scope + '\'' + '}';
    }
}

