/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.protobuf.events.notifications.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import io.confluent.protobuf.events.notifications.v1.AlertMetadata;
import io.confluent.protobuf.events.notifications.v1.AlertMetadataOrBuilder;
import io.confluent.protobuf.events.notifications.v1.AlertMetric;
import io.confluent.protobuf.events.notifications.v1.AlertMetricOrBuilder;
import io.confluent.protobuf.events.notifications.v1.AlertOrBuilder;
import io.confluent.protobuf.events.notifications.v1.AlertProto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class Alert
extends GeneratedMessageV3
implements AlertOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RULE_ID_FIELD_NUMBER = 1;
    private volatile Object ruleId_;
    public static final int RULE_NAME_FIELD_NUMBER = 2;
    private volatile Object ruleName_;
    public static final int ORG_ID_FIELD_NUMBER = 3;
    private volatile Object orgId_;
    public static final int SEVERITY_FIELD_NUMBER = 4;
    private int severity_;
    public static final int STATUS_FIELD_NUMBER = 5;
    private int status_;
    public static final int RESOURCE_FIELD_NUMBER = 6;
    private volatile Object resource_;
    public static final int METRIC_FIELD_NUMBER = 7;
    private AlertMetric metric_;
    public static final int CREATED_AT_FIELD_NUMBER = 8;
    private Timestamp createdAt_;
    public static final int METADATA_FIELD_NUMBER = 9;
    private AlertMetadata metadata_;
    public static final int TYPE_FIELD_NUMBER = 10;
    private volatile Object type_;
    public static final int LABELS_FIELD_NUMBER = 11;
    private MapField<String, String> labels_;
    public static final int ORG_RESOURCE_ID_FIELD_NUMBER = 12;
    private volatile Object orgResourceId_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Alert DEFAULT_INSTANCE = new Alert();
    private static final Parser<Alert> PARSER = new AbstractParser<Alert>(){

        public Alert parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new Alert(input, extensionRegistry);
        }
    };

    private Alert(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Alert() {
        this.ruleId_ = "";
        this.ruleName_ = "";
        this.orgId_ = "";
        this.severity_ = 0;
        this.status_ = 0;
        this.resource_ = "";
        this.type_ = "";
        this.orgResourceId_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Alert();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private Alert(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block21: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block21;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.ruleId_ = s;
                        continue block21;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.ruleName_ = s;
                        continue block21;
                    }
                    case 26: {
                        String s = input.readStringRequireUtf8();
                        this.orgId_ = s;
                        continue block21;
                    }
                    case 32: {
                        int rawValue;
                        this.severity_ = rawValue = input.readEnum();
                        continue block21;
                    }
                    case 40: {
                        int rawValue;
                        this.status_ = rawValue = input.readEnum();
                        continue block21;
                    }
                    case 50: {
                        String s = input.readStringRequireUtf8();
                        this.resource_ = s;
                        continue block21;
                    }
                    case 58: {
                        AlertMetric.Builder subBuilder = null;
                        if (this.metric_ != null) {
                            subBuilder = this.metric_.toBuilder();
                        }
                        this.metric_ = (AlertMetric)input.readMessage(AlertMetric.parser(), extensionRegistry);
                        if (subBuilder == null) continue block21;
                        subBuilder.mergeFrom(this.metric_);
                        this.metric_ = subBuilder.buildPartial();
                        continue block21;
                    }
                    case 66: {
                        Timestamp.Builder subBuilder = null;
                        if (this.createdAt_ != null) {
                            subBuilder = this.createdAt_.toBuilder();
                        }
                        this.createdAt_ = (Timestamp)input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block21;
                        subBuilder.mergeFrom(this.createdAt_);
                        this.createdAt_ = subBuilder.buildPartial();
                        continue block21;
                    }
                    case 74: {
                        AlertMetadata.Builder subBuilder = null;
                        if (this.metadata_ != null) {
                            subBuilder = this.metadata_.toBuilder();
                        }
                        this.metadata_ = (AlertMetadata)input.readMessage(AlertMetadata.parser(), extensionRegistry);
                        if (subBuilder == null) continue block21;
                        subBuilder.mergeFrom(this.metadata_);
                        this.metadata_ = subBuilder.buildPartial();
                        continue block21;
                    }
                    case 82: {
                        String s = input.readStringRequireUtf8();
                        this.type_ = s;
                        continue block21;
                    }
                    case 90: {
                        if (!(mutable_bitField0_ & true)) {
                            this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= true;
                        }
                        MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
                        continue block21;
                    }
                    case 98: {
                        String s = input.readStringRequireUtf8();
                        this.orgResourceId_ = s;
                        continue block21;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AlertProto.internal_static_notifications_v1_Alert_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 11: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AlertProto.internal_static_notifications_v1_Alert_fieldAccessorTable.ensureFieldAccessorsInitialized(Alert.class, Builder.class);
    }

    @Override
    public String getRuleId() {
        Object ref = this.ruleId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.ruleId_ = s;
        return s;
    }

    @Override
    public ByteString getRuleIdBytes() {
        Object ref = this.ruleId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.ruleId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRuleName() {
        Object ref = this.ruleName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.ruleName_ = s;
        return s;
    }

    @Override
    public ByteString getRuleNameBytes() {
        Object ref = this.ruleName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.ruleName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getOrgId() {
        Object ref = this.orgId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orgId_ = s;
        return s;
    }

    @Override
    public ByteString getOrgIdBytes() {
        Object ref = this.orgId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orgId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getSeverityValue() {
        return this.severity_;
    }

    @Override
    public Severity getSeverity() {
        Severity result = Severity.valueOf(this.severity_);
        return result == null ? Severity.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public Status getStatus() {
        Status result = Status.valueOf(this.status_);
        return result == null ? Status.UNRECOGNIZED : result;
    }

    @Override
    public String getResource() {
        Object ref = this.resource_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resource_ = s;
        return s;
    }

    @Override
    public ByteString getResourceBytes() {
        Object ref = this.resource_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resource_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMetric() {
        return this.metric_ != null;
    }

    @Override
    public AlertMetric getMetric() {
        return this.metric_ == null ? AlertMetric.getDefaultInstance() : this.metric_;
    }

    @Override
    public AlertMetricOrBuilder getMetricOrBuilder() {
        return this.getMetric();
    }

    @Override
    public boolean hasCreatedAt() {
        return this.createdAt_ != null;
    }

    @Override
    public Timestamp getCreatedAt() {
        return this.createdAt_ == null ? Timestamp.getDefaultInstance() : this.createdAt_;
    }

    @Override
    public TimestampOrBuilder getCreatedAtOrBuilder() {
        return this.getCreatedAt();
    }

    @Override
    public boolean hasMetadata() {
        return this.metadata_ != null;
    }

    @Override
    public AlertMetadata getMetadata() {
        return this.metadata_ == null ? AlertMetadata.getDefaultInstance() : this.metadata_;
    }

    @Override
    public AlertMetadataOrBuilder getMetadataOrBuilder() {
        return this.getMetadata();
    }

    @Override
    @Deprecated
    public String getType() {
        Object ref = this.type_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.type_ = s;
        return s;
    }

    @Override
    @Deprecated
    public ByteString getTypeBytes() {
        Object ref = this.type_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.type_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getOrgResourceId() {
        Object ref = this.orgResourceId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orgResourceId_ = s;
        return s;
    }

    @Override
    public ByteString getOrgResourceIdBytes() {
        Object ref = this.orgResourceId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orgResourceId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.ruleId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.ruleId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.ruleName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.ruleName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.orgId_);
        }
        if (this.severity_ != Severity.INFO.getNumber()) {
            output.writeEnum(4, this.severity_);
        }
        if (this.status_ != Status.RAISED.getNumber()) {
            output.writeEnum(5, this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resource_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.resource_);
        }
        if (this.metric_ != null) {
            output.writeMessage(7, (MessageLite)this.getMetric());
        }
        if (this.createdAt_ != null) {
            output.writeMessage(8, (MessageLite)this.getCreatedAt());
        }
        if (this.metadata_ != null) {
            output.writeMessage(9, (MessageLite)this.getMetadata());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.type_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.type_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)11);
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgResourceId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.orgResourceId_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.ruleId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.ruleId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.ruleName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.ruleName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgId_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.orgId_);
        }
        if (this.severity_ != Severity.INFO.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.severity_);
        }
        if (this.status_ != Status.RAISED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resource_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.resource_);
        }
        if (this.metric_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getMetric());
        }
        if (this.createdAt_ != null) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getCreatedAt());
        }
        if (this.metadata_ != null) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getMetadata());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.type_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.type_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)labels__);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgResourceId_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.orgResourceId_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Alert)) {
            return super.equals(obj);
        }
        Alert other = (Alert)obj;
        if (!this.getRuleId().equals(other.getRuleId())) {
            return false;
        }
        if (!this.getRuleName().equals(other.getRuleName())) {
            return false;
        }
        if (!this.getOrgId().equals(other.getOrgId())) {
            return false;
        }
        if (this.severity_ != other.severity_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (!this.getResource().equals(other.getResource())) {
            return false;
        }
        if (this.hasMetric() != other.hasMetric()) {
            return false;
        }
        if (this.hasMetric() && !this.getMetric().equals(other.getMetric())) {
            return false;
        }
        if (this.hasCreatedAt() != other.hasCreatedAt()) {
            return false;
        }
        if (this.hasCreatedAt() && !this.getCreatedAt().equals((Object)other.getCreatedAt())) {
            return false;
        }
        if (this.hasMetadata() != other.hasMetadata()) {
            return false;
        }
        if (this.hasMetadata() && !this.getMetadata().equals(other.getMetadata())) {
            return false;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getOrgResourceId().equals(other.getOrgResourceId())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Alert.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getRuleId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getRuleName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getOrgId().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.severity_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getResource().hashCode();
        if (this.hasMetric()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getMetric().hashCode();
        }
        if (this.hasCreatedAt()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getCreatedAt().hashCode();
        }
        if (this.hasMetadata()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getMetadata().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getType().hashCode();
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getOrgResourceId().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static Alert parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Alert)PARSER.parseFrom(data);
    }

    public static Alert parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Alert)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Alert parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Alert)PARSER.parseFrom(data);
    }

    public static Alert parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Alert)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Alert parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Alert)PARSER.parseFrom(data);
    }

    public static Alert parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Alert)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Alert parseFrom(InputStream input) throws IOException {
        return (Alert)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Alert parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Alert)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Alert parseDelimitedFrom(InputStream input) throws IOException {
        return (Alert)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Alert parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Alert)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Alert parseFrom(CodedInputStream input) throws IOException {
        return (Alert)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Alert parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Alert)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Alert.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Alert prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Alert getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Alert> parser() {
        return PARSER;
    }

    public Parser<Alert> getParserForType() {
        return PARSER;
    }

    public Alert getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AlertOrBuilder {
        private int bitField0_;
        private Object ruleId_ = "";
        private Object ruleName_ = "";
        private Object orgId_ = "";
        private int severity_ = 0;
        private int status_ = 0;
        private Object resource_ = "";
        private AlertMetric metric_;
        private SingleFieldBuilderV3<AlertMetric, AlertMetric.Builder, AlertMetricOrBuilder> metricBuilder_;
        private Timestamp createdAt_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createdAtBuilder_;
        private AlertMetadata metadata_;
        private SingleFieldBuilderV3<AlertMetadata, AlertMetadata.Builder, AlertMetadataOrBuilder> metadataBuilder_;
        private Object type_ = "";
        private MapField<String, String> labels_;
        private Object orgResourceId_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return AlertProto.internal_static_notifications_v1_Alert_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 11: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 11: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AlertProto.internal_static_notifications_v1_Alert_fieldAccessorTable.ensureFieldAccessorsInitialized(Alert.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.ruleId_ = "";
            this.ruleName_ = "";
            this.orgId_ = "";
            this.severity_ = 0;
            this.status_ = 0;
            this.resource_ = "";
            if (this.metricBuilder_ == null) {
                this.metric_ = null;
            } else {
                this.metric_ = null;
                this.metricBuilder_ = null;
            }
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = null;
            } else {
                this.createdAt_ = null;
                this.createdAtBuilder_ = null;
            }
            if (this.metadataBuilder_ == null) {
                this.metadata_ = null;
            } else {
                this.metadata_ = null;
                this.metadataBuilder_ = null;
            }
            this.type_ = "";
            this.internalGetMutableLabels().clear();
            this.orgResourceId_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AlertProto.internal_static_notifications_v1_Alert_descriptor;
        }

        public Alert getDefaultInstanceForType() {
            return Alert.getDefaultInstance();
        }

        public Alert build() {
            Alert result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Alert buildPartial() {
            Alert result = new Alert(this);
            int from_bitField0_ = this.bitField0_;
            result.ruleId_ = this.ruleId_;
            result.ruleName_ = this.ruleName_;
            result.orgId_ = this.orgId_;
            result.severity_ = this.severity_;
            result.status_ = this.status_;
            result.resource_ = this.resource_;
            if (this.metricBuilder_ == null) {
                result.metric_ = this.metric_;
            } else {
                result.metric_ = (AlertMetric)this.metricBuilder_.build();
            }
            if (this.createdAtBuilder_ == null) {
                result.createdAt_ = this.createdAt_;
            } else {
                result.createdAt_ = (Timestamp)this.createdAtBuilder_.build();
            }
            if (this.metadataBuilder_ == null) {
                result.metadata_ = this.metadata_;
            } else {
                result.metadata_ = (AlertMetadata)this.metadataBuilder_.build();
            }
            result.type_ = this.type_;
            result.labels_ = this.internalGetLabels();
            result.labels_.makeImmutable();
            result.orgResourceId_ = this.orgResourceId_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Alert) {
                return this.mergeFrom((Alert)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Alert other) {
            if (other == Alert.getDefaultInstance()) {
                return this;
            }
            if (!other.getRuleId().isEmpty()) {
                this.ruleId_ = other.ruleId_;
                this.onChanged();
            }
            if (!other.getRuleName().isEmpty()) {
                this.ruleName_ = other.ruleName_;
                this.onChanged();
            }
            if (!other.getOrgId().isEmpty()) {
                this.orgId_ = other.orgId_;
                this.onChanged();
            }
            if (other.severity_ != 0) {
                this.setSeverityValue(other.getSeverityValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (!other.getResource().isEmpty()) {
                this.resource_ = other.resource_;
                this.onChanged();
            }
            if (other.hasMetric()) {
                this.mergeMetric(other.getMetric());
            }
            if (other.hasCreatedAt()) {
                this.mergeCreatedAt(other.getCreatedAt());
            }
            if (other.hasMetadata()) {
                this.mergeMetadata(other.getMetadata());
            }
            if (!other.getType().isEmpty()) {
                this.type_ = other.type_;
                this.onChanged();
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            if (!other.getOrgResourceId().isEmpty()) {
                this.orgResourceId_ = other.orgResourceId_;
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            Alert parsedMessage = null;
            try {
                parsedMessage = (Alert)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (Alert)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getRuleId() {
            Object ref = this.ruleId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.ruleId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRuleIdBytes() {
            Object ref = this.ruleId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.ruleId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRuleId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ruleId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRuleId() {
            this.ruleId_ = Alert.getDefaultInstance().getRuleId();
            this.onChanged();
            return this;
        }

        public Builder setRuleIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Alert.checkByteStringIsUtf8((ByteString)value);
            this.ruleId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getRuleName() {
            Object ref = this.ruleName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.ruleName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRuleNameBytes() {
            Object ref = this.ruleName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.ruleName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRuleName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ruleName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRuleName() {
            this.ruleName_ = Alert.getDefaultInstance().getRuleName();
            this.onChanged();
            return this;
        }

        public Builder setRuleNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Alert.checkByteStringIsUtf8((ByteString)value);
            this.ruleName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getOrgId() {
            Object ref = this.orgId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orgId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrgIdBytes() {
            Object ref = this.orgId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orgId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrgId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orgId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearOrgId() {
            this.orgId_ = Alert.getDefaultInstance().getOrgId();
            this.onChanged();
            return this;
        }

        public Builder setOrgIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Alert.checkByteStringIsUtf8((ByteString)value);
            this.orgId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getSeverityValue() {
            return this.severity_;
        }

        public Builder setSeverityValue(int value) {
            this.severity_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Severity getSeverity() {
            Severity result = Severity.valueOf(this.severity_);
            return result == null ? Severity.UNRECOGNIZED : result;
        }

        public Builder setSeverity(Severity value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.severity_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSeverity() {
            this.severity_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Status getStatus() {
            Status result = Status.valueOf(this.status_);
            return result == null ? Status.UNRECOGNIZED : result;
        }

        public Builder setStatus(Status value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getResource() {
            Object ref = this.resource_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resource_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceBytes() {
            Object ref = this.resource_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resource_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResource(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resource_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResource() {
            this.resource_ = Alert.getDefaultInstance().getResource();
            this.onChanged();
            return this;
        }

        public Builder setResourceBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Alert.checkByteStringIsUtf8((ByteString)value);
            this.resource_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMetric() {
            return this.metricBuilder_ != null || this.metric_ != null;
        }

        @Override
        public AlertMetric getMetric() {
            if (this.metricBuilder_ == null) {
                return this.metric_ == null ? AlertMetric.getDefaultInstance() : this.metric_;
            }
            return (AlertMetric)this.metricBuilder_.getMessage();
        }

        public Builder setMetric(AlertMetric value) {
            if (this.metricBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.metric_ = value;
                this.onChanged();
            } else {
                this.metricBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setMetric(AlertMetric.Builder builderForValue) {
            if (this.metricBuilder_ == null) {
                this.metric_ = builderForValue.build();
                this.onChanged();
            } else {
                this.metricBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeMetric(AlertMetric value) {
            if (this.metricBuilder_ == null) {
                this.metric_ = this.metric_ != null ? AlertMetric.newBuilder(this.metric_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.metricBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearMetric() {
            if (this.metricBuilder_ == null) {
                this.metric_ = null;
                this.onChanged();
            } else {
                this.metric_ = null;
                this.metricBuilder_ = null;
            }
            return this;
        }

        public AlertMetric.Builder getMetricBuilder() {
            this.onChanged();
            return (AlertMetric.Builder)this.getMetricFieldBuilder().getBuilder();
        }

        @Override
        public AlertMetricOrBuilder getMetricOrBuilder() {
            if (this.metricBuilder_ != null) {
                return (AlertMetricOrBuilder)this.metricBuilder_.getMessageOrBuilder();
            }
            return this.metric_ == null ? AlertMetric.getDefaultInstance() : this.metric_;
        }

        private SingleFieldBuilderV3<AlertMetric, AlertMetric.Builder, AlertMetricOrBuilder> getMetricFieldBuilder() {
            if (this.metricBuilder_ == null) {
                this.metricBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMetric(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.metric_ = null;
            }
            return this.metricBuilder_;
        }

        @Override
        public boolean hasCreatedAt() {
            return this.createdAtBuilder_ != null || this.createdAt_ != null;
        }

        @Override
        public Timestamp getCreatedAt() {
            if (this.createdAtBuilder_ == null) {
                return this.createdAt_ == null ? Timestamp.getDefaultInstance() : this.createdAt_;
            }
            return (Timestamp)this.createdAtBuilder_.getMessage();
        }

        public Builder setCreatedAt(Timestamp value) {
            if (this.createdAtBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createdAt_ = value;
                this.onChanged();
            } else {
                this.createdAtBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setCreatedAt(Timestamp.Builder builderForValue) {
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = builderForValue.build();
                this.onChanged();
            } else {
                this.createdAtBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeCreatedAt(Timestamp value) {
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = this.createdAt_ != null ? Timestamp.newBuilder((Timestamp)this.createdAt_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.createdAtBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearCreatedAt() {
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = null;
                this.onChanged();
            } else {
                this.createdAt_ = null;
                this.createdAtBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getCreatedAtBuilder() {
            this.onChanged();
            return (Timestamp.Builder)this.getCreatedAtFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreatedAtOrBuilder() {
            if (this.createdAtBuilder_ != null) {
                return (TimestampOrBuilder)this.createdAtBuilder_.getMessageOrBuilder();
            }
            return this.createdAt_ == null ? Timestamp.getDefaultInstance() : this.createdAt_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreatedAtFieldBuilder() {
            if (this.createdAtBuilder_ == null) {
                this.createdAtBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreatedAt(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createdAt_ = null;
            }
            return this.createdAtBuilder_;
        }

        @Override
        public boolean hasMetadata() {
            return this.metadataBuilder_ != null || this.metadata_ != null;
        }

        @Override
        public AlertMetadata getMetadata() {
            if (this.metadataBuilder_ == null) {
                return this.metadata_ == null ? AlertMetadata.getDefaultInstance() : this.metadata_;
            }
            return (AlertMetadata)this.metadataBuilder_.getMessage();
        }

        public Builder setMetadata(AlertMetadata value) {
            if (this.metadataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.metadata_ = value;
                this.onChanged();
            } else {
                this.metadataBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setMetadata(AlertMetadata.Builder builderForValue) {
            if (this.metadataBuilder_ == null) {
                this.metadata_ = builderForValue.build();
                this.onChanged();
            } else {
                this.metadataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeMetadata(AlertMetadata value) {
            if (this.metadataBuilder_ == null) {
                this.metadata_ = this.metadata_ != null ? AlertMetadata.newBuilder(this.metadata_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.metadataBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearMetadata() {
            if (this.metadataBuilder_ == null) {
                this.metadata_ = null;
                this.onChanged();
            } else {
                this.metadata_ = null;
                this.metadataBuilder_ = null;
            }
            return this;
        }

        public AlertMetadata.Builder getMetadataBuilder() {
            this.onChanged();
            return (AlertMetadata.Builder)this.getMetadataFieldBuilder().getBuilder();
        }

        @Override
        public AlertMetadataOrBuilder getMetadataOrBuilder() {
            if (this.metadataBuilder_ != null) {
                return (AlertMetadataOrBuilder)this.metadataBuilder_.getMessageOrBuilder();
            }
            return this.metadata_ == null ? AlertMetadata.getDefaultInstance() : this.metadata_;
        }

        private SingleFieldBuilderV3<AlertMetadata, AlertMetadata.Builder, AlertMetadataOrBuilder> getMetadataFieldBuilder() {
            if (this.metadataBuilder_ == null) {
                this.metadataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMetadata(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.metadata_ = null;
            }
            return this.metadataBuilder_;
        }

        @Override
        @Deprecated
        public String getType() {
            Object ref = this.type_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.type_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        @Deprecated
        public ByteString getTypeBytes() {
            Object ref = this.type_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.type_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Deprecated
        public Builder setType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.type_ = value;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder clearType() {
            this.type_ = Alert.getDefaultInstance().getType();
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder setTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Alert.checkByteStringIsUtf8((ByteString)value);
            this.type_ = value;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            this.onChanged();
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            return this;
        }

        @Override
        public String getOrgResourceId() {
            Object ref = this.orgResourceId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orgResourceId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrgResourceIdBytes() {
            Object ref = this.orgResourceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orgResourceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrgResourceId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orgResourceId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearOrgResourceId() {
            this.orgResourceId_ = Alert.getDefaultInstance().getOrgResourceId();
            this.onChanged();
            return this;
        }

        public Builder setOrgResourceIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Alert.checkByteStringIsUtf8((ByteString)value);
            this.orgResourceId_ = value;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)AlertProto.internal_static_notifications_v1_Alert_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum Status implements ProtocolMessageEnum
    {
        RAISED(0),
        CLEARED(1),
        UNRECOGNIZED(-1);

        public static final int RAISED_VALUE = 0;
        public static final int CLEARED_VALUE = 1;
        private static final Internal.EnumLiteMap<Status> internalValueMap;
        private static final Status[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Status valueOf(int value) {
            return Status.forNumber(value);
        }

        public static Status forNumber(int value) {
            switch (value) {
                case 0: {
                    return RAISED;
                }
                case 1: {
                    return CLEARED;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Status> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Status.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Status.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Alert.getDescriptor().getEnumTypes().get(1);
        }

        public static Status valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Status.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Status(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Status>(){

                public Status findValueByNumber(int number) {
                    return Status.forNumber(number);
                }
            };
            VALUES = Status.values();
        }
    }

    public static enum Severity implements ProtocolMessageEnum
    {
        INFO(0),
        WARN(1),
        CRITICAL(2),
        UNRECOGNIZED(-1);

        public static final int INFO_VALUE = 0;
        public static final int WARN_VALUE = 1;
        public static final int CRITICAL_VALUE = 2;
        private static final Internal.EnumLiteMap<Severity> internalValueMap;
        private static final Severity[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Severity valueOf(int value) {
            return Severity.forNumber(value);
        }

        public static Severity forNumber(int value) {
            switch (value) {
                case 0: {
                    return INFO;
                }
                case 1: {
                    return WARN;
                }
                case 2: {
                    return CRITICAL;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Severity> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Severity.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Severity.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Alert.getDescriptor().getEnumTypes().get(0);
        }

        public static Severity valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Severity.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Severity(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Severity>(){

                public Severity findValueByNumber(int number) {
                    return Severity.forNumber(number);
                }
            };
            VALUES = Severity.values();
        }
    }
}

