/*
 * Decompiled with CFR 0.152.
 */
package io.kcache;

import io.kcache.Cache;
import io.kcache.CacheLoader;
import io.kcache.CacheType;
import io.kcache.CacheUpdateHandler;
import io.kcache.KafkaCacheConfig;
import io.kcache.KeyValueIterator;
import io.kcache.exceptions.CacheException;
import io.kcache.exceptions.CacheInitializationException;
import io.kcache.exceptions.CacheTimeoutException;
import io.kcache.exceptions.EntryTooLargeException;
import io.kcache.utils.InMemoryBoundedCache;
import io.kcache.utils.InMemoryCache;
import io.kcache.utils.OffsetCheckpoint;
import io.kcache.utils.ShutdownableThread;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(KafkaCache.class);
    private String topic;
    private int desiredReplicationFactor;
    private int desiredNumPartitions;
    private List<Integer> partitions;
    private KafkaCacheConfig.Offset offset;
    private String groupId;
    private String clientId;
    private CacheUpdateHandler<K, V> cacheUpdateHandler;
    private Serde<K> keySerde;
    private Serde<V> valueSerde;
    private Cache<K, V> localCache;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private boolean skipValidation;
    private boolean requireCompact;
    private boolean readOnly;
    private int initTimeout;
    private int timeout;
    private long pollTimeout;
    private String checkpointDir;
    private int checkpointVersion;
    private String bootstrapBrokers;
    private Producer<byte[], byte[]> producer;
    private Partitioner partitioner;
    private Consumer<byte[], byte[]> consumer;
    private WorkerThread kafkaTopicReader;
    private KafkaCacheConfig config;
    private OffsetCheckpoint checkpointFile;
    private final Map<TopicPartition, Long> checkpointFileCache = new HashMap<TopicPartition, Long>();
    private final Map<Integer, Long> lastWrittenOffsets = new ConcurrentHashMap<Integer, Long>();
    private final Queue<CompletableFuture<Integer>> syncCallbacks = new ArrayDeque<CompletableFuture<Integer>>();

    public KafkaCache(String bootstrapServers, Serde<K> keySerde, Serde<V> valueSerde) {
        Properties props = new Properties();
        props.put("kafkacache.bootstrap.servers", bootstrapServers);
        this.setUp(new KafkaCacheConfig(props), keySerde, valueSerde, null, null, null, null);
    }

    public KafkaCache(KafkaCacheConfig config, Serde<K> keySerde, Serde<V> valueSerde) {
        this.setUp(config, keySerde, valueSerde, null, null, null, null);
    }

    public KafkaCache(KafkaCacheConfig config, Serde<K> keySerde, Serde<V> valueSerde, CacheUpdateHandler<K, V> cacheUpdateHandler, Cache<K, V> localCache) {
        this.setUp(config, keySerde, valueSerde, cacheUpdateHandler, null, null, localCache);
    }

    public KafkaCache(KafkaCacheConfig config, Serde<K> keySerde, Serde<V> valueSerde, CacheUpdateHandler<K, V> cacheUpdateHandler, String backingCacheName, Comparator<K> comparator) {
        this.setUp(config, keySerde, valueSerde, cacheUpdateHandler, backingCacheName, comparator, null);
    }

    private void setUp(KafkaCacheConfig config, Serde<K> keySerde, Serde<V> valueSerde, CacheUpdateHandler<K, V> cacheUpdateHandler, String backingCacheName, Comparator<K> comparator, Cache<K, V> localCache) {
        this.config = config;
        this.topic = config.getString("kafkacache.topic");
        this.desiredReplicationFactor = config.getInt("kafkacache.topic.replication.factor");
        this.desiredNumPartitions = config.getInt("kafkacache.topic.num.partitions");
        this.partitions = config.partitions();
        this.offset = config.offset();
        this.groupId = config.getString("kafkacache.group.id");
        this.clientId = config.getString("kafkacache.client.id");
        if (this.clientId == null) {
            this.clientId = "kafka-cache-reader-" + this.topic;
        }
        this.skipValidation = config.getBoolean("kafkacache.topic.skip.validation");
        this.requireCompact = config.getBoolean("kafkacache.topic.require.compact");
        this.readOnly = config.getBoolean("kafkacache.topic.read.only");
        this.initTimeout = config.getInt("kafkacache.init.timeout.ms");
        this.timeout = config.getInt("kafkacache.timeout.ms");
        this.pollTimeout = config.getLong("kafkacache.poll.timeout.ms");
        this.checkpointDir = config.getString("kafkacache.checkpoint.dir");
        this.checkpointVersion = config.getInt("kafkacache.checkpoint.version");
        this.cacheUpdateHandler = cacheUpdateHandler != null ? cacheUpdateHandler : (key, value, oldValue, tp, offset, ts) -> {};
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.localCache = localCache != null ? localCache : this.createLocalCache(backingCacheName, comparator);
        this.bootstrapBrokers = config.bootstrapBrokers();
        log.info("Initializing Kafka cache {} with broker endpoints {}", (Object)this.clientId, (Object)this.bootstrapBrokers);
    }

    private Cache<K, V> createLocalCache(String backingCacheName, Comparator<K> cmp) {
        try {
            Cache cache;
            if (backingCacheName == null) {
                backingCacheName = "default";
            }
            CacheType cacheType = CacheType.get(this.config.getString("kafkacache.backing.cache"));
            int maxSize = this.config.getInt("kafkacache.bounded.cache.size");
            int expiry = this.config.getInt("kafkacache.bounded.cache.expiry.secs");
            String clsName = null;
            boolean isPersistent = false;
            switch (cacheType) {
                case MEMORY: {
                    return maxSize >= 0 || expiry >= 0 ? new InMemoryBoundedCache(maxSize, Duration.ofSeconds(expiry), null, cmp) : new InMemoryCache(cmp);
                }
                case BDBJE: {
                    clsName = "io.kcache.bdbje.BdbJECache";
                    isPersistent = true;
                    break;
                }
                case CAFFEINE: {
                    clsName = "io.kcache.caffeine.CaffeineCache";
                    break;
                }
                case LMDB: {
                    clsName = "io.kcache.lmdb.LmdbCache";
                    isPersistent = true;
                    break;
                }
                case MAPDB: {
                    clsName = "io.kcache.mapdb.MapDBCache";
                    isPersistent = true;
                    break;
                }
                case RDBMS: {
                    clsName = "io.kcache.rdbms.RdbmsCache";
                    isPersistent = true;
                    break;
                }
                case ROCKSDB: {
                    clsName = "io.kcache.rocksdb.RocksDBCache";
                    isPersistent = true;
                }
            }
            Class<?> cls = Class.forName(clsName);
            if (isPersistent) {
                String dataDir = this.config.getString("kafkacache.data.dir");
                Constructor<?> ctor = cls.getConstructor(String.class, String.class, Serde.class, Serde.class, Comparator.class);
                cache = (Cache)ctor.newInstance(backingCacheName, dataDir, this.keySerde, this.valueSerde, cmp);
            } else {
                Constructor<?> ctor = cls.getConstructor(Integer.class, Duration.class, CacheLoader.class, Comparator.class);
                cache = (Cache)ctor.newInstance(maxSize, Duration.ofSeconds(expiry), null, cmp);
            }
            Map configs = this.config.originalsWithPrefix("kafkacache.backing.cache." + (Object)((Object)cacheType) + ".");
            cache.configure(configs);
            return cache;
        }
        catch (Exception e) {
            throw new CacheInitializationException("Could not create backing cache", e);
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.localCache.comparator();
    }

    @Override
    public boolean isPersistent() {
        return this.localCache.isPersistent();
    }

    @Override
    public void init() throws CacheInitializationException {
        int count;
        if (this.initialized.get()) {
            throw new CacheInitializationException("Illegal state while initializing cache for " + this.clientId + ". Cache was already initialized");
        }
        if (this.localCache.isPersistent()) {
            try {
                this.checkpointFile = new OffsetCheckpoint(this.checkpointDir, this.checkpointVersion, this.topic);
                this.checkpointFileCache.putAll(this.checkpointFile.read());
            }
            catch (IOException e) {
                throw new CacheInitializationException("Failed to read checkpoints", e);
            }
            log.info("Successfully read checkpoints");
        }
        this.localCache.init();
        if (!this.skipValidation) {
            this.createOrVerifyTopic();
        }
        this.consumer = new KafkaConsumer(this.getConsumerProperties());
        if (!this.readOnly) {
            Properties producerProperties = this.getProducerProperties();
            this.producer = new KafkaProducer(producerProperties);
            ProducerConfig producerConfig = new ProducerConfig(producerProperties);
            this.partitioner = (Partitioner)producerConfig.getConfiguredInstance("partitioner.class", Partitioner.class, Collections.singletonMap("client.id", this.clientId));
        }
        this.kafkaTopicReader = new WorkerThread();
        try {
            count = this.kafkaTopicReader.readToEndOffsets(Duration.ofMillis(this.initTimeout));
        }
        catch (IOException e) {
            throw new CacheInitializationException("Failed to read to end offsets", e);
        }
        this.kafkaTopicReader.start();
        boolean isInitialized = this.initialized.compareAndSet(false, true);
        if (!isInitialized) {
            throw new CacheInitializationException("Illegal state while initializing cache for " + this.clientId + ". Cache was already initialized");
        }
        this.cacheUpdateHandler.cacheInitialized(count, new HashMap<TopicPartition, Long>(this.checkpointFileCache));
    }

    @Override
    public void reset() {
        this.lastWrittenOffsets.clear();
        this.localCache.reset();
        this.cacheUpdateHandler.cacheReset();
    }

    @Override
    public void sync() {
        int count = -1;
        if (this.kafkaTopicReader != null) {
            count = this.kafkaTopicReader.waitUntilLastWrittenOffsets(Duration.ofMillis(this.timeout));
        }
        if (count < 0) {
            count = this.waitUntilEndOffsets();
        }
        this.localCache.sync();
        this.cacheUpdateHandler.cacheSynchronized(count, new HashMap<TopicPartition, Long>(this.checkpointFileCache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitUntilEndOffsets() throws CacheException {
        CompletableFuture future = new CompletableFuture();
        KafkaCache kafkaCache = this;
        synchronized (kafkaCache) {
            this.syncCallbacks.add(future);
        }
        if (this.consumer != null) {
            this.consumer.wakeup();
        }
        int count = 0;
        try {
            count = (Integer)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to read to end offsets", (Throwable)e);
        }
        return count;
    }

    private Properties getConsumerProperties() {
        Properties consumerProps = new Properties();
        this.addKafkaCacheConfigsToClientProperties(consumerProps);
        consumerProps.put("group.id", this.groupId);
        consumerProps.put("client.id", this.clientId);
        consumerProps.put("bootstrap.servers", this.bootstrapBrokers);
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("key.deserializer", ByteArrayDeserializer.class);
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class);
        return consumerProps;
    }

    private Properties getProducerProperties() {
        Properties producerProps = new Properties();
        this.addKafkaCacheConfigsToClientProperties(producerProps);
        producerProps.put("bootstrap.servers", this.bootstrapBrokers);
        producerProps.put("acks", "-1");
        producerProps.put("key.serializer", ByteArraySerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        producerProps.put("retries", (Object)0);
        producerProps.put("enable.idempotence", (Object)false);
        return producerProps;
    }

    private void addKafkaCacheConfigsToClientProperties(Properties props) {
        props.putAll((Map<?, ?>)this.config.originalsWithPrefix("kafkacache."));
    }

    private void createOrVerifyTopic() throws CacheInitializationException {
        block11: {
            Properties props = new Properties();
            this.addKafkaCacheConfigsToClientProperties(props);
            props.put("bootstrap.servers", this.bootstrapBrokers);
            try (AdminClient admin = AdminClient.create((Properties)props);){
                Set allTopics = (Set)admin.listTopics().names().get((long)this.initTimeout, TimeUnit.MILLISECONDS);
                if (allTopics.contains(this.topic)) {
                    this.verifyTopic(admin);
                    break block11;
                }
                if (!this.readOnly) {
                    this.createTopic(admin);
                    break block11;
                }
                throw new CacheInitializationException("Topic does not exist " + this.topic + " and cache is configured read-only");
            }
            catch (TimeoutException e) {
                throw new CacheInitializationException("Timed out trying to create or validate topic " + this.topic, e);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CacheInitializationException("Failed trying to create or validate topic " + this.topic, e);
            }
        }
    }

    private void createTopic(AdminClient admin) throws CacheInitializationException, InterruptedException, ExecutionException, TimeoutException {
        log.info("Creating topic {}", (Object)this.topic);
        int numLiveBrokers = ((Collection)admin.describeCluster().nodes().get((long)this.initTimeout, TimeUnit.MILLISECONDS)).size();
        if (numLiveBrokers <= 0) {
            throw new CacheInitializationException("No live Kafka brokers");
        }
        int topicReplicationFactor = Math.min(numLiveBrokers, this.desiredReplicationFactor);
        if (topicReplicationFactor < this.desiredReplicationFactor) {
            log.warn("Creating the topic " + this.topic + " using a replication factor of " + topicReplicationFactor + ", which is less than the desired one of " + this.desiredReplicationFactor + ". If this is a production environment, it's crucial to add more brokers and increase the replication factor of the topic.");
        }
        NewTopic topicRequest = new NewTopic(this.topic, this.desiredNumPartitions, (short)topicReplicationFactor);
        Map<String, String> topicConfigs = this.config.originalsWithPrefix("kafkacache.topic.config.").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        topicConfigs.put("cleanup.policy", "compact");
        topicRequest.configs(topicConfigs);
        try {
            admin.createTopics(Collections.singleton(topicRequest)).all().get((long)this.initTimeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e2) {
            if (e2.getCause() instanceof TopicExistsException) {
                this.verifyTopic(admin);
            }
            throw e2;
        }
    }

    private void verifyTopic(AdminClient admin) throws CacheInitializationException, InterruptedException, ExecutionException, TimeoutException {
        ConfigResource topicResource;
        Map configs;
        Config topicConfigs;
        String retentionPolicy;
        Map topicDescription;
        log.info("Validating topic {}", (Object)this.topic);
        Set<String> topics = Collections.singleton(this.topic);
        try {
            topicDescription = (Map)admin.describeTopics(topics).allTopicNames().get((long)this.initTimeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                log.warn("Could not validate existing topic {}", (Object)this.topic);
                return;
            }
            throw e;
        }
        TopicDescription description = (TopicDescription)topicDescription.get(this.topic);
        int numPartitions = description.partitions().size();
        if (numPartitions < this.desiredNumPartitions) {
            log.warn("The number of partitions for the topic " + this.topic + " is less than the desired value of " + this.desiredReplicationFactor + ".");
        }
        if (((TopicPartitionInfo)description.partitions().get(0)).replicas().size() < this.desiredReplicationFactor) {
            log.warn("The replication factor of the topic " + this.topic + " is less than the desired one of " + this.desiredReplicationFactor + ". If this is a production environment, it's crucial to add more brokers and increase the replication factor of the topic.");
        }
        if (!"compact".equals(retentionPolicy = (topicConfigs = (Config)(configs = (Map)admin.describeConfigs(Collections.singleton(topicResource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic))).all().get((long)this.initTimeout, TimeUnit.MILLISECONDS)).get(topicResource)).get("cleanup.policy").value())) {
            String message = "The retention policy of the topic " + this.topic + " is not 'compact'. You must configure the topic to 'compact' cleanup policy to avoid Kafka deleting your data after a week. Refer to Kafka documentation for more details on cleanup policies.";
            if (this.requireCompact) {
                log.error(message);
                throw new CacheInitializationException("The retention policy of the topic " + this.topic + " is incorrect. Expected cleanup.policy to be 'compact' but it is " + retentionPolicy);
            }
            log.warn(message);
        }
    }

    @Override
    public int size() {
        this.assertInitialized();
        return this.localCache.size();
    }

    @Override
    public boolean isEmpty() {
        this.assertInitialized();
        return this.localCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.assertInitialized();
        return this.localCache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.assertInitialized();
        return this.localCache.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.assertInitialized();
        return this.localCache.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.put(null, key, value).getOldValue();
    }

    public Metadata<V> put(Headers headers, K key, V value) {
        return this.put(headers, key, value, false);
    }

    public Metadata<V> put(Headers headers, K key, V value, boolean flush) {
        if (this.readOnly) {
            throw new CacheException("Cache is read-only");
        }
        this.assertInitialized();
        Object oldValue = key != null ? (Object)this.get(key) : null;
        RecordMetadata recordMetadata = this.doPut(() -> {
            ProducerRecord<byte[], byte[]> producerRecord = this.toRecord(headers, key, value);
            log.trace("Sending record to Kafka cache topic: {}", producerRecord);
            Future ack = this.producer.send(producerRecord);
            if (flush) {
                this.producer.flush();
            }
            return ack;
        });
        return new Metadata<Object>(recordMetadata, oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) {
        this.putAll(null, entries);
    }

    public RecordMetadata putAll(Headers headers, Map<? extends K, ? extends V> entries) {
        return this.putAll(headers, entries, true);
    }

    public RecordMetadata putAll(Headers headers, Map<? extends K, ? extends V> entries, boolean flush) {
        if (this.readOnly) {
            throw new CacheException("Cache is read-only");
        }
        this.assertInitialized();
        if (entries.isEmpty()) {
            return null;
        }
        return this.doPut(() -> {
            Future ack = null;
            for (Map.Entry entry : entries.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                ProducerRecord<byte[], byte[]> producerRecord = this.toRecord(headers, key, value);
                log.trace("Sending record to Kafka cache topic: {}", producerRecord);
                ack = this.producer.send(producerRecord);
            }
            if (flush) {
                this.producer.flush();
            }
            return ack;
        });
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RecordMetadata doPut(Supplier<Future<RecordMetadata>> ackSupplier) {
        Integer lastWrittenPartition = null;
        Long previousWrittenOffset = null;
        boolean knownSuccessfulWrite = false;
        try {
            Future<RecordMetadata> ack = ackSupplier.get();
            RecordMetadata recordMetadata = ack.get(this.timeout, TimeUnit.MILLISECONDS);
            log.trace("Waiting for the local cache to catch up to offset {}", (Object)recordMetadata.offset());
            lastWrittenPartition = recordMetadata.partition();
            long lastWrittenOffset = recordMetadata.offset();
            previousWrittenOffset = this.lastWrittenOffsets.put(lastWrittenPartition, lastWrittenOffset);
            this.kafkaTopicReader.waitUntilOffset(lastWrittenPartition, lastWrittenOffset, Duration.ofMillis(this.timeout));
            return recordMetadata;
        }
        catch (InterruptedException e) {
            try {
                throw new CacheException("Put operation interrupted while waiting for an ack from Kafka", e);
                catch (ExecutionException e2) {
                    if (!(e2.getCause() instanceof RecordTooLargeException)) throw new CacheException("Put operation failed while waiting for an ack from Kafka", e2);
                    throw new EntryTooLargeException("Put operation failed because entry is too large");
                }
                catch (TimeoutException e3) {
                    throw new CacheTimeoutException("Put operation timed out while waiting for an ack from Kafka", e3);
                }
                catch (KafkaException ke) {
                    throw new CacheException("Put operation to Kafka failed", ke);
                }
            }
            catch (Throwable throwable) {
                if (knownSuccessfulWrite) throw throwable;
                if (lastWrittenPartition == null) throw throwable;
                if (previousWrittenOffset != null) {
                    this.lastWrittenOffsets.put(lastWrittenPartition, previousWrittenOffset);
                    throw throwable;
                }
                this.lastWrittenOffsets.remove(lastWrittenPartition);
                throw throwable;
            }
        }
    }

    private ProducerRecord<byte[], byte[]> toRecord(Headers headers, K key, V value) {
        ProducerRecord producerRecord;
        try {
            byte[] keyBytes = key == null ? null : this.keySerde.serializer().serialize(this.topic, headers, key);
            byte[] valueBytes = value == null ? null : this.valueSerde.serializer().serialize(this.topic, headers, value);
            producerRecord = new ProducerRecord(this.topic, this.partition(this.topic, key, keyBytes, value, valueBytes), (Object)keyBytes, (Object)valueBytes, (Iterable)headers);
        }
        catch (Exception e) {
            throw new CacheException("Error serializing key while creating the Kafka produce record", e);
        }
        return producerRecord;
    }

    private Integer partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes) {
        if (this.partitioner == null || this.partitioner instanceof DefaultPartitioner) {
            return null;
        }
        try {
            int customPartition = this.partitioner.partition(topic, key, keyBytes, value, valueBytes, null);
            if (customPartition < 0) {
                throw new IllegalArgumentException(String.format("The partitioner generated an invalid partition number: %d. Partition number should always be non-negative.", customPartition));
            }
            return customPartition;
        }
        catch (Exception e) {
            log.warn("Could not invoke partitioner", (Throwable)e);
            return null;
        }
    }

    @Override
    public V remove(Object key) {
        return this.put(key, null);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        this.assertInitialized();
        return this.readOnly ? Collections.unmodifiableSet(this.localCache.keySet()) : this.localCache.keySet();
    }

    @Override
    public Collection<V> values() {
        this.assertInitialized();
        return this.readOnly ? Collections.unmodifiableCollection(this.localCache.values()) : this.localCache.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.assertInitialized();
        return this.readOnly ? Collections.unmodifiableSet(this.localCache.entrySet()) : this.localCache.entrySet();
    }

    @Override
    public K firstKey() {
        this.assertInitialized();
        return this.localCache.firstKey();
    }

    @Override
    public K lastKey() {
        this.assertInitialized();
        return this.localCache.lastKey();
    }

    @Override
    public Cache<K, V> subCache(K from, boolean fromInclusive, K to, boolean toInclusive) {
        this.assertInitialized();
        return this.localCache.subCache(from, fromInclusive, to, toInclusive);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, boolean fromInclusive, K to, boolean toInclusive) {
        this.assertInitialized();
        return this.localCache.range(from, fromInclusive, to, toInclusive);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        this.assertInitialized();
        return this.localCache.all();
    }

    @Override
    public Cache<K, V> descendingCache() {
        this.assertInitialized();
        return this.localCache.descendingCache();
    }

    @Override
    public void flush() {
        if (this.producer != null) {
            this.producer.flush();
        }
        this.localCache.flush();
        this.cacheUpdateHandler.cacheFlushed();
    }

    @Override
    public void close() throws IOException {
        if (this.kafkaTopicReader != null) {
            try {
                this.kafkaTopicReader.shutdown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Utils.closeQuietly(this.producer, (String)("Kafka cache producer for " + this.clientId));
        this.localCache.close();
        if (this.checkpointFile != null) {
            this.checkpointFile.close();
        }
        this.cacheUpdateHandler.close();
        log.info("Kafka cache shut down complete for {}", (Object)this.clientId);
    }

    @Override
    public void destroy() throws IOException {
        this.localCache.destroy();
        this.cacheUpdateHandler.cacheDestroyed();
    }

    private void assertInitialized() throws CacheException {
        if (!this.initialized.get()) {
            throw new CacheException("Illegal state. Cache for " + this.clientId + " not initialized yet");
        }
    }

    WorkerThread getWorkerThread() {
        return this.kafkaTopicReader;
    }

    static /* synthetic */ long access$1400(KafkaCache x0) {
        return x0.pollTimeout;
    }

    static /* synthetic */ CacheUpdateHandler access$1500(KafkaCache x0) {
        return x0.cacheUpdateHandler;
    }

    static /* synthetic */ Serde access$1600(KafkaCache x0) {
        return x0.keySerde;
    }

    static /* synthetic */ Serde access$1700(KafkaCache x0) {
        return x0.valueSerde;
    }

    static /* synthetic */ boolean access$1800(KafkaCache x0) {
        return x0.readOnly;
    }

    static /* synthetic */ Producer access$1900(KafkaCache x0) {
        return x0.producer;
    }

    static /* synthetic */ AtomicBoolean access$2000(KafkaCache x0) {
        return x0.initialized;
    }

    public static class Metadata<V> {
        private final RecordMetadata recordMetadata;
        private final V oldValue;

        public Metadata(RecordMetadata recordMetadata, V oldValue) {
            this.recordMetadata = recordMetadata;
            this.oldValue = oldValue;
        }

        public RecordMetadata getRecordMetadata() {
            return this.recordMetadata;
        }

        public V getOldValue() {
            return this.oldValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metadata metadata = (Metadata)o;
            return Objects.equals(this.recordMetadata, metadata.recordMetadata) && Objects.equals(this.oldValue, metadata.oldValue);
        }

        public int hashCode() {
            return Objects.hash(this.recordMetadata, this.oldValue);
        }

        public String toString() {
            return "Metadata{recordMetadata=" + this.recordMetadata + ", oldValue=" + this.oldValue + '}';
        }
    }

    private class WorkerThread
    extends ShutdownableThread {
        private final ReentrantLock offsetUpdateLock;
        private final Condition offsetReachedThreshold;
        private final Map<Integer, Long> lastReadOffsets;

        public WorkerThread() {
            super("kafka-cache-reader-thread-" + KafkaCache.this.topic);
            this.lastReadOffsets = new ConcurrentHashMap<Integer, Long>();
            this.offsetUpdateLock = new ReentrantLock();
            this.offsetReachedThreshold = this.offsetUpdateLock.newCondition();
            if (KafkaCache.this.partitions.isEmpty()) {
                int retries = 0;
                while (retries++ < 10) {
                    List partitionInfos = KafkaCache.this.consumer.partitionsFor(KafkaCache.this.topic, Duration.ofMillis(KafkaCache.this.initTimeout));
                    if (partitionInfos != null && !partitionInfos.isEmpty()) {
                        KafkaCache.this.partitions = partitionInfos.stream().map(PartitionInfo::partition).collect(Collectors.toList());
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (KafkaCache.this.partitions.isEmpty()) {
                    throw new IllegalArgumentException("Unable to subscribe to the Kafka topic " + KafkaCache.this.topic + " backing this data cache. Topic may not exist.");
                }
            }
            List<TopicPartition> topicPartitions = KafkaCache.this.partitions.stream().peek(p -> this.lastReadOffsets.put((Integer)p, -1L)).map(p -> new TopicPartition(KafkaCache.this.topic, p.intValue())).collect(Collectors.toList());
            KafkaCache.this.consumer.assign(topicPartitions);
            if (KafkaCache.this.localCache.isPersistent()) {
                for (TopicPartition topicPartition : topicPartitions) {
                    Long checkpoint = (Long)KafkaCache.this.checkpointFileCache.get(topicPartition);
                    if (checkpoint != null) {
                        log.info("Seeking to checkpoint {} for {}", (Object)checkpoint, (Object)topicPartition);
                        KafkaCache.this.consumer.seek(topicPartition, checkpoint.longValue());
                        continue;
                    }
                    log.info("Seeking to start for {}", (Object)topicPartition);
                    this.seekToStart(Collections.singleton(topicPartition), Duration.ofMillis(KafkaCache.this.initTimeout));
                }
            } else {
                log.info("Seeking to start for all partitions for topic {}", (Object)KafkaCache.this.topic);
                this.seekToStart(topicPartitions, Duration.ofMillis(KafkaCache.this.initTimeout));
            }
            log.info("Initialized last read offsets to {}", this.lastReadOffsets);
            log.info("KafkaTopicReader thread started for {}.", (Object)KafkaCache.this.clientId);
        }

        private int readToEndOffsets(Duration timeout) throws IOException {
            Set assignment = KafkaCache.this.consumer.assignment();
            Map endOffsets = KafkaCache.this.consumer.endOffsets((Collection)assignment, timeout);
            log.info("Reading to end of offsets {}", (Object)endOffsets);
            int count = 0;
            while (!this.hasReadToEndOffsets(endOffsets, timeout)) {
                try {
                    count += this.poll();
                }
                catch (InvalidOffsetException e) {
                    if (KafkaCache.this.localCache.isPersistent()) {
                        KafkaCache.this.localCache.close();
                        KafkaCache.this.localCache.destroy();
                        KafkaCache.this.localCache.init();
                    }
                    log.warn("Seeking to start due to invalid offset", (Throwable)e);
                    this.seekToStart(assignment, timeout);
                    count = 0;
                }
            }
            log.info("During init or sync, processed {} records from topic {}", (Object)count, (Object)KafkaCache.this.topic);
            return count;
        }

        private void seekToStart(Collection<TopicPartition> topicPartitions, Duration timeout) {
            switch (KafkaCache.this.offset.getOffsetType()) {
                case BEGINNING: {
                    KafkaCache.this.consumer.seekToBeginning(topicPartitions);
                    break;
                }
                case END: {
                    KafkaCache.this.consumer.seekToEnd(topicPartitions);
                    break;
                }
                case ABSOLUTE: {
                    for (TopicPartition tp2 : topicPartitions) {
                        KafkaCache.this.consumer.seek(tp2, KafkaCache.this.offset.getOffset());
                    }
                    break;
                }
                case RELATIVE: {
                    Map endOffsets = KafkaCache.this.consumer.endOffsets(topicPartitions, timeout);
                    for (TopicPartition tp3 : topicPartitions) {
                        KafkaCache.this.consumer.seek(tp3, Math.max((Long)endOffsets.get(tp3) - KafkaCache.this.offset.getOffset(), 0L));
                    }
                    break;
                }
                case TIMESTAMP: {
                    Map<TopicPartition, Long> timestamps = topicPartitions.stream().collect(Collectors.toMap(tp -> tp, tp -> KafkaCache.this.offset.getOffset()));
                    Map offsets = null;
                    try {
                        offsets = KafkaCache.this.consumer.offsetsForTimes(timestamps, timeout);
                    }
                    catch (KafkaException e) {
                        log.warn("Could not fetch offset times for topic {}", (Object)KafkaCache.this.topic, (Object)e);
                    }
                    for (TopicPartition tp4 : topicPartitions) {
                        if (offsets != null && offsets.get(tp4) != null) {
                            KafkaCache.this.consumer.seek(tp4, ((OffsetAndTimestamp)offsets.get(tp4)).offset());
                            continue;
                        }
                        KafkaCache.this.consumer.seekToBeginning(Collections.singleton(tp4));
                        log.warn("Could not find offset time for topic {}, partition {}, ts {}, seeking to beginning", new Object[]{tp4.topic(), tp4.partition(), KafkaCache.this.offset.getOffset()});
                    }
                    break;
                }
            }
        }

        private boolean hasReadToEndOffsets(Map<TopicPartition, Long> endOffsets, Duration timeout) {
            endOffsets.entrySet().removeIf(entry -> KafkaCache.this.consumer.position((TopicPartition)entry.getKey(), timeout) >= (Long)entry.getValue());
            return endOffsets.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWork() {
            int numCallbacks;
            KafkaCache kafkaCache = KafkaCache.this;
            synchronized (kafkaCache) {
                numCallbacks = KafkaCache.this.syncCallbacks.size();
            }
            int count = 0;
            if (numCallbacks > 0) {
                try {
                    count = this.readToEndOffsets(Duration.ofMillis(KafkaCache.this.timeout));
                }
                catch (IOException | KafkaException e) {
                    log.error("Error while reading to end offsets", e);
                    return;
                }
            }
            KafkaCache kafkaCache2 = KafkaCache.this;
            synchronized (kafkaCache2) {
                for (int i = 0; i < numCallbacks; ++i) {
                    CompletableFuture cb = (CompletableFuture)KafkaCache.this.syncCallbacks.poll();
                    if (cb == null) continue;
                    cb.complete(count);
                }
            }
            this.poll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private int poll() {
            block27: {
                count = 0;
                try {
                    records = KafkaCache.access$600(KafkaCache.this).poll(Duration.ofMillis(KafkaCache.access$1400(KafkaCache.this)));
                    count = records.count();
                    KafkaCache.access$1500(KafkaCache.this).startBatch(count);
lbl6:
                    // 12 sources

                    block22: for (ConsumerRecord record : records) {
                        try {
                            try {
                                messageKey = KafkaCache.access$1600(KafkaCache.this).deserializer().deserialize(KafkaCache.access$300(KafkaCache.this), record.headers(), (byte[])record.key());
                            }
                            catch (Exception e) {
                                KafkaCache.access$900().error("Failed to deserialize the key", (Throwable)e);
                                this.updateOffset(record.partition(), record.offset());
                                continue;
                            }
                            try {
                                message = record.value() == null ? null : KafkaCache.access$1700(KafkaCache.this).deserializer().deserialize(KafkaCache.access$300(KafkaCache.this), record.headers(), (byte[])record.value());
                            }
                            catch (Exception e) {
                                KafkaCache.access$900().error("Failed to deserialize a value", (Throwable)e);
                                this.updateOffset(record.partition(), record.offset());
                                continue;
                            }
                            headers = record.headers();
                            tp = new TopicPartition(record.topic(), record.partition());
                            offset = record.offset();
                            timestamp = record.timestamp();
                            tsType = record.timestampType();
                            leaderEpoch = record.leaderEpoch();
                            status = KafkaCache.access$1500(KafkaCache.this).validateUpdate(headers, messageKey, message, tp, offset, timestamp, tsType, leaderEpoch);
                            oldMessage = null;
                            switch (1.$SwitchMap$io$kcache$CacheUpdateHandler$ValidationStatus[status.ordinal()]) {
                                case 1: {
                                    if (messageKey != null) {
                                        KafkaCache.access$900().trace("Applying update ({}, {}) to the local cache", messageKey, message);
                                        oldMessage = message == null ? (Object)KafkaCache.access$700(KafkaCache.this).remove(messageKey) : KafkaCache.access$700(KafkaCache.this).put(messageKey, message);
                                    }
                                    KafkaCache.access$1500(KafkaCache.this).handleUpdate(headers, messageKey, message, oldMessage, tp, offset, timestamp, tsType, leaderEpoch);
                                    ** break;
                                }
                                case 2: {
                                    if (KafkaCache.access$1800(KafkaCache.this) || messageKey == null) {
                                        KafkaCache.access$900().warn("Ignore invalid update to key {}", messageKey);
                                        ** break;
                                    }
                                    oldMessage = KafkaCache.access$700(KafkaCache.this).get(messageKey);
                                    if (Objects.equals(message, oldMessage)) ** break;
                                    try {
                                        producerRecord = new ProducerRecord(record.topic(), Integer.valueOf(record.partition()), (Object)((byte[])record.key()), oldMessage == null ? null : KafkaCache.access$1700(KafkaCache.this).serializer().serialize(KafkaCache.access$300(KafkaCache.this), headers, oldMessage), (Iterable)headers);
                                        KafkaCache.access$1900(KafkaCache.this).send(producerRecord);
                                        KafkaCache.access$900().warn("Rollback invalid update to key {}", messageKey);
                                    }
                                    catch (KafkaException ke) {
                                        KafkaCache.access$900().error("Failed to rollback invalid update to key {}", messageKey, (Object)ke);
                                    }
                                    continue block22;
                                }
                                case 3: {
                                    KafkaCache.access$900().warn("Ignore invalid update to key {}", messageKey);
                                    continue block22;
                                }
                                ** default:
lbl56:
                                // 1 sources

                                continue block22;
                            }
                        }
                        catch (Exception se) {
                            KafkaCache.access$900().error("Failed to add record from the Kafka topic " + KafkaCache.access$300(KafkaCache.this) + " to the local cache", (Throwable)se);
                        }
                        finally {
                            this.updateOffset(record.partition(), record.offset());
                        }
                    }
                    if (KafkaCache.access$700(KafkaCache.this).isPersistent() && KafkaCache.access$2000(KafkaCache.this).get()) {
                        try {
                            KafkaCache.access$700(KafkaCache.this).flush();
                            offsets = KafkaCache.access$1500(KafkaCache.this).checkpoint(count);
                            this.checkpointOffsets(offsets);
                        }
                        catch (CacheException e) {
                            KafkaCache.access$900().warn("Failed to flush", (Throwable)e);
                        }
                    }
                    KafkaCache.access$1500(KafkaCache.this).endBatch(count);
                }
                catch (Throwable t) {
                    KafkaCache.access$1500(KafkaCache.this).failBatch(count, t);
                    if (t instanceof WakeupException) break block27;
                    if (t instanceof KafkaException) {
                        KafkaCache.access$900().error("Error while polling", t);
                    }
                    KafkaCache.access$900().error("KafkaTopicReader thread for {} has died for an unknown reason.", (Object)KafkaCache.access$1000(KafkaCache.this), (Object)t);
                    throw t;
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateOffset(int partition, long offset) {
            try {
                this.offsetUpdateLock.lock();
                this.lastReadOffsets.put(partition, offset);
                this.offsetReachedThreshold.signalAll();
            }
            finally {
                this.offsetUpdateLock.unlock();
            }
        }

        private void checkpointOffsets(Map<TopicPartition, Long> offsets) {
            Map<TopicPartition, Long> newOffsets = offsets != null ? offsets : this.lastReadOffsets.entrySet().stream().collect(Collectors.toMap(e -> new TopicPartition(KafkaCache.this.topic, ((Integer)e.getKey()).intValue()), e -> (Long)e.getValue() + 1L));
            KafkaCache.this.checkpointFileCache.putAll(newOffsets);
            try {
                KafkaCache.this.checkpointFile.write(KafkaCache.this.checkpointFileCache);
            }
            catch (IOException e2) {
                log.warn("Failed to write offset checkpoint file to {}: {}", (Object)KafkaCache.this.checkpointFile, (Object)e2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilOffset(int partition, long offset, Duration timeout) throws CacheException {
            if (offset < 0L) {
                throw new CacheException("KafkaTopicReader thread can't wait for a negative offset.");
            }
            log.trace("Waiting to read offset {}. Currently at offset {}", (Object)offset, (Object)this.lastReadOffsets.get(partition));
            try {
                this.offsetUpdateLock.lock();
                long timeoutNs = timeout.toNanos();
                while (this.lastReadOffsets.get(partition) < offset && timeoutNs > 0L) {
                    try {
                        timeoutNs = this.offsetReachedThreshold.awaitNanos(timeoutNs);
                    }
                    catch (InterruptedException e) {
                        log.debug("Interrupted while waiting for the background cache reader thread to reach the specified offset: " + offset, (Throwable)e);
                    }
                }
            }
            finally {
                this.offsetUpdateLock.unlock();
            }
            if (this.lastReadOffsets.get(partition) < offset) {
                throw new CacheTimeoutException("KafkaCacheTopic thread failed to reach target offset within the timeout interval. targetOffset: " + offset + ", offsetReached: " + this.lastReadOffsets.get(partition) + ", timeout(ms): " + timeout.toMillis());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int waitUntilLastWrittenOffsets(Duration timeout) throws CacheException {
            HashMap<Integer, Long> lastOffsets = new HashMap<Integer, Long>(KafkaCache.this.lastWrittenOffsets);
            if (!this.hasValidLastWrittenOffsets(lastOffsets)) {
                return -1;
            }
            int count = this.countUnreadOffsets(lastOffsets);
            if (count == 0) {
                return count;
            }
            try {
                this.offsetUpdateLock.lock();
                long timeoutNs = timeout.toNanos();
                while (this.countUnreadOffsets(lastOffsets) > 0 && timeoutNs > 0L) {
                    try {
                        timeoutNs = this.offsetReachedThreshold.awaitNanos(timeoutNs);
                    }
                    catch (InterruptedException e) {
                        log.debug("Interrupted while waiting for the background cache reader thread to reach the end offsets", (Throwable)e);
                    }
                }
            }
            finally {
                this.offsetUpdateLock.unlock();
            }
            if (this.countUnreadOffsets(lastOffsets) == 0) {
                return count;
            }
            log.warn("Could not read to last written offsets {}", lastOffsets);
            return -1;
        }

        private boolean hasValidLastWrittenOffsets(Map<Integer, Long> lastOffsets) {
            return lastOffsets.keySet().containsAll(KafkaCache.this.partitions);
        }

        private int countUnreadOffsets(Map<Integer, Long> lastOffsets) {
            return lastOffsets.entrySet().stream().map(entry -> {
                int lastWrittenPartition = (Integer)entry.getKey();
                long lastWrittenOffset = (Long)entry.getValue();
                long lastReadOffset = this.lastReadOffsets.getOrDefault(lastWrittenPartition, -1L);
                return Math.max((int)(lastWrittenOffset - lastReadOffset), 0);
            }).reduce(0, Integer::sum);
        }

        @Override
        public void shutdown() throws InterruptedException {
            log.debug("Starting shutdown of KafkaTopicReader thread for {}.", (Object)KafkaCache.this.clientId);
            super.initiateShutdown();
            if (KafkaCache.this.consumer != null) {
                KafkaCache.this.consumer.wakeup();
            }
            super.awaitShutdown();
            Utils.closeQuietly((AutoCloseable)KafkaCache.this.consumer, (String)("Kafka cache consumer for " + KafkaCache.this.clientId));
            log.info("KafkaTopicReader thread shutdown complete for {}.", (Object)KafkaCache.this.clientId);
        }
    }
}

