/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.security.Principal;
import org.apache.kafka.common.network.AbstractTransportLayer;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class PlaintextTransportLayer
extends AbstractTransportLayer {
    private final Principal principal = KafkaPrincipal.ANONYMOUS;

    public PlaintextTransportLayer(SelectionKey key, ProxyProtocolEngine proxyProtocolEngine) throws IOException {
        super(key, proxyProtocolEngine);
        this.netReadBuffer = ByteBuffer.allocate(1024);
    }

    @Override
    public boolean ready() {
        return this.proxyProtocolReady();
    }

    @Override
    public void selectionKey(SelectionKey newKey) {
        this.key = newKey;
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.socket().close();
        this.socketChannel.close();
        this.netReadBuffer = null;
    }

    @Override
    public void handshake() {
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = 0;
        if (this.netReadBuffer.position() > 0) {
            read = this.readFromNetReadBuffer(dst);
        }
        return read + this.socketChannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        if (dsts.length == 1) {
            return this.read(dsts[0]);
        }
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long read = 0L;
        for (ByteBuffer dst : dsts) {
            if (this.netReadBuffer.position() <= 0) break;
            read += (long)this.readFromNetReadBuffer(dst);
        }
        return read + this.socketChannel.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socketChannel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        if (srcs.length == 1) {
            return this.write(srcs[0]);
        }
        return this.socketChannel.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socketChannel.write(srcs, offset, length);
    }

    @Override
    public boolean hasPendingWrites() {
        return false;
    }

    @Override
    public Principal peerPrincipal() {
        return this.principal;
    }

    @Override
    public void addInterestOps(int ops) {
        this.key.interestOps(this.key.interestOps() | ops);
    }

    @Override
    public void removeInterestOps(int ops) {
        this.key.interestOps(this.key.interestOps() & ~ops);
    }

    @Override
    public boolean isMute() {
        return this.key.isValid() && (this.key.interestOps() & 1) == 0;
    }

    @Override
    public boolean hasBytesBuffered() {
        return false;
    }

    @Override
    public long transferFrom(FileChannel fileChannel, long position, long count) throws IOException {
        return fileChannel.transferTo(position, count, this.socketChannel);
    }

    @Override
    public void handleProxyProtocol() throws IOException {
        Mode mode = this.proxyProtocolEngine.mode();
        if (mode == Mode.SERVER) {
            this.maybeReadAndProcessProxyHeaders();
        } else if (mode == Mode.CLIENT && this.proxyProtocolEngine.includeOutgoingProxyHeader()) {
            Socket socket = this.socketChannel.socket();
            byte[] header = this.proxyProtocolEngine.emitHeaders(socket.getInetAddress(), socket.getPort());
            ByteBuffer buf = ByteBuffer.wrap(header);
            this.write(buf);
        }
    }

    private int readFromNetReadBuffer(ByteBuffer dst) {
        this.netReadBuffer.flip();
        int remaining = Math.min(this.netReadBuffer.remaining(), dst.remaining());
        if (remaining > 0) {
            int limit = this.netReadBuffer.limit();
            this.netReadBuffer.limit(this.netReadBuffer.position() + remaining);
            dst.put(this.netReadBuffer);
            this.netReadBuffer.limit(limit);
        }
        this.netReadBuffer.compact();
        return remaining;
    }
}

