/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.replica.ReplicaStatus;

@InterfaceStability.Evolving
@Confluent
public class ReplicaStatusResult {
    private final Map<TopicPartition, KafkaFuture<PartitionResult>> result;

    public ReplicaStatusResult(Map<TopicPartition, KafkaFuture<PartitionResult>> result) {
        this.result = result;
    }

    public Map<TopicPartition, KafkaFuture<List<ReplicaStatus>>> result() {
        HashMap<TopicPartition, KafkaFuture<List<ReplicaStatus>>> mappedResult = new HashMap<TopicPartition, KafkaFuture<List<ReplicaStatus>>>();
        for (Map.Entry<TopicPartition, KafkaFuture<PartitionResult>> entry : this.result.entrySet()) {
            mappedResult.put(entry.getKey(), entry.getValue().thenApply(PartitionResult::replicas));
        }
        return mappedResult;
    }

    public KafkaFuture<Void> all() {
        return KafkaFuture.allOf(this.result.values().toArray(new KafkaFuture[0]));
    }

    public Map<TopicPartition, KafkaFuture<PartitionResult>> partitionResults() {
        return this.result;
    }

    public KafkaFuture<Map<TopicPartition, PartitionResult>> allResults() {
        return KafkaFuture.allOf(this.result.values().toArray(new KafkaFuture[0])).thenApply(aVoid -> {
            HashMap<TopicPartition, PartitionResult> partitions = new HashMap<TopicPartition, PartitionResult>(this.result.size());
            for (Map.Entry<TopicPartition, KafkaFuture<PartitionResult>> entry : this.result.entrySet()) {
                try {
                    partitions.put(entry.getKey(), entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return partitions;
        });
    }
}

