/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.implementation.KeyVaultCredentialPolicy;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.subtle.Validators;
import io.confluent.kafka.schemaregistry.encryption.azure.AzureKmsAead;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Locale;

public final class AzureKmsClient
implements KmsClient {
    public static final String PREFIX = "azure-kms://";
    private CryptographyClient cryptographyClient;
    private String keyUri;
    private TokenCredential provider;
    private static final EncryptionAlgorithm DEFAULT_ENCRYPTION_ALGORITHM = EncryptionAlgorithm.RSA_OAEP_256;
    private EncryptionAlgorithm algorithm = DEFAULT_ENCRYPTION_ALGORITHM;

    public AzureKmsClient() {
    }

    public AzureKmsClient(String uri) {
        this(uri, DEFAULT_ENCRYPTION_ALGORITHM);
    }

    public AzureKmsClient(String uri, EncryptionAlgorithm algorithm) {
        if (uri == null || uri.isEmpty()) {
            throw new IllegalArgumentException("key URI must not be blank");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm must not be null");
        }
        if (!uri.toLowerCase(Locale.US).startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must starts with azure-kms://");
        }
        this.keyUri = uri;
        this.algorithm = algorithm;
    }

    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    public KmsClient withCredentials(String credentialPath) throws GeneralSecurityException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        return this.withCredentialsProvider((TokenCredential)new DefaultAzureCredentialBuilder().build());
    }

    public KmsClient withCredentialsProvider(TokenCredential provider) throws GeneralSecurityException {
        this.provider = provider;
        return this;
    }

    public KmsClient withCryptographyClient(CryptographyClient cryptographyClient) {
        this.cryptographyClient = cryptographyClient;
        return this;
    }

    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        String keyUri = Validators.validateKmsKeyUriAndRemovePrefix((String)PREFIX, (String)uri);
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new KeyVaultCredentialPolicy((TokenCredential)(this.provider == null ? new DefaultAzureCredentialBuilder().build() : this.provider), false), new RetryPolicy((RetryStrategy)new ExponentialBackoff(5, Duration.ofSeconds(1L), Duration.ofSeconds(16L)))}).build();
        CryptographyClient client = this.cryptographyClient;
        if (client == null) {
            client = new CryptographyClientBuilder().pipeline(pipeline).keyIdentifier(keyUri).buildClient();
        }
        return new AzureKmsAead(client, this.algorithm);
    }
}

