/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logredactor;

import io.confluent.log4j.redactor.LogRedactorMetrics;
import io.confluent.shaded.com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;

public class KafkaSensorLogRedactorMetrics
implements LogRedactorMetrics {
    private static final String METRICS_NAMESPACE = "confluent.logredactor";
    private static final String GROUP_NAME = "logredactor-metrics";
    private final Metrics metrics;
    private Map<ImmutableMap, String> sensors = new HashMap<ImmutableMap, String>();

    public KafkaSensorLogRedactorMetrics() {
        this.metrics = new Metrics(new MetricConfig(), Collections.singletonList(new JmxReporter()), Time.SYSTEM, (MetricsContext)new KafkaMetricsContext(METRICS_NAMESPACE));
    }

    public void count(String metricName, Map<String, String> tags) {
        this.record(1.0, metricName, tags, MetricType.COUNT);
    }

    public void timer(double value, String metricName, Map<String, String> tags) {
        this.record(value, metricName, tags, MetricType.TIMER);
    }

    public void gauge(double value, String metricName, Map<String, String> tags) {
        this.record(value, metricName, tags, MetricType.GAUGE);
    }

    private void record(double value, String metricName, Map<String, String> tags, MetricType type) {
        Sensor sensor;
        HashMap<String, String> sensorInfo = new HashMap<String, String>(tags);
        sensorInfo.put("metricName", metricName);
        String sensorName = this.sensors.get(sensorInfo);
        if (sensorName != null) {
            sensor = this.metrics.getSensor(sensorName);
        } else {
            TreeMap<String, String> sortedTags = new TreeMap<String, String>(tags);
            sensorName = metricName + ":";
            for (Map.Entry<String, String> tag : sortedTags.entrySet()) {
                sensorName = sensorName.concat(tag.toString());
            }
            sensor = this.metrics.sensor(sensorName);
            if (type == MetricType.COUNT) {
                sensor.add(this.metrics.metricName(metricName, GROUP_NAME, tags), (MeasurableStat)new CumulativeCount());
            } else {
                sensor.add(this.metrics.metricName(metricName, GROUP_NAME, tags), (MeasurableStat)new Value());
            }
            this.sensors.put(ImmutableMap.copyOf(sensorInfo), sensorName);
        }
        sensor.record(value);
    }

    private static enum MetricType {
        COUNT,
        GAUGE,
        TIMER;

    }
}

