/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics.reporter;

import io.confluent.shaded.com.google.common.base.MoreObjects;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeMetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(VolumeMetricsProvider.class);
    private final long updatePeriodMs;
    private final String[] logDirs;
    private long lastUpdateNs;
    private Map<String, VolumeInfo> cachedMetrics = null;

    public VolumeMetricsProvider(long updatePeriodMs, String[] logDirs) {
        this.updatePeriodMs = updatePeriodMs;
        this.logDirs = logDirs;
    }

    public Map<String, VolumeInfo> getMetrics() {
        long curTimeNs = System.nanoTime();
        long deltaNs = curTimeNs - this.lastUpdateNs;
        long deltaMs = TimeUnit.MILLISECONDS.convert(deltaNs, TimeUnit.NANOSECONDS);
        if (deltaMs >= this.updatePeriodMs) {
            this.cachedMetrics = null;
        }
        if (this.cachedMetrics == null) {
            this.lastUpdateNs = curTimeNs;
            this.cachedMetrics = this.refreshCachedMetrics();
        }
        return Collections.unmodifiableMap(this.cachedMetrics);
    }

    private Map<String, VolumeInfo> refreshCachedMetrics() {
        HashMap<String, FileStore> fileStoreNameToObject = new HashMap<String, FileStore>();
        HashMap fileStoreNameToLogDirs = new HashMap();
        for (String logDir : this.logDirs) {
            try {
                FileStore fileStore = this.pathToFileStore(logDir);
                fileStoreNameToObject.put(fileStore.name(), fileStore);
                if (!fileStoreNameToLogDirs.containsKey(fileStore.name())) {
                    fileStoreNameToLogDirs.put(fileStore.name(), new TreeSet());
                }
                ((Set)fileStoreNameToLogDirs.get(fileStore.name())).add(logDir);
            }
            catch (IOException e) {
                log.error("Failed to resolve path to FileStore", (Throwable)e);
            }
        }
        TreeMap<String, VolumeInfo> metrics = new TreeMap<String, VolumeInfo>();
        for (FileStore fileStore : fileStoreNameToObject.values()) {
            try {
                VolumeInfo volumeInfo = new VolumeInfo(fileStore, (Set)fileStoreNameToLogDirs.get(fileStore.name()));
                if (log.isDebugEnabled()) {
                    log.debug("Read {}", (Object)volumeInfo.toString());
                }
                metrics.put(volumeInfo.name(), volumeInfo);
            }
            catch (IOException | RuntimeException e) {
                log.error("Failed to retrieve VolumeInfo from FileStore", (Throwable)e);
            }
        }
        return metrics;
    }

    private FileStore pathToFileStore(String path) throws IOException {
        Path pathObj = Paths.get(path, new String[0]);
        return Files.getFileStore(pathObj);
    }

    public static class VolumeInfo {
        private final String name;
        private final long usableBytes;
        private final long totalBytes;
        private final Set<String> logDirs;

        private VolumeInfo(FileStore fileStore, Set<String> logDirs) throws IOException {
            this.name = fileStore.name();
            this.usableBytes = fileStore.getUsableSpace();
            this.totalBytes = fileStore.getTotalSpace();
            this.logDirs = Collections.unmodifiableSet(logDirs);
        }

        public String name() {
            return this.name;
        }

        public long usableBytes() {
            return this.usableBytes;
        }

        public long totalBytes() {
            return this.totalBytes;
        }

        public Collection<String> logDirs() {
            return this.logDirs;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("usableBytes", this.usableBytes).add("totalBytes", this.totalBytes).add("logDirs", this.logDirs).toString();
        }
    }
}

