/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics.reporter;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.stats.Snapshot;
import io.confluent.metrics.reporter.ConfluentMetricsReporter;
import io.confluent.metrics.reporter.Utils;
import io.confluent.shaded.io.confluent.metrics.record.ConfluentMetric;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YammerMetricsHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfluentMetricsReporter.class);
    private final ConfluentMetric.YammerMetricName.Builder metricNameBuilder = ConfluentMetric.YammerMetricName.newBuilder();
    private final ConfluentMetric.YammerGauge.Builder gaugeBuilder = ConfluentMetric.YammerGauge.newBuilder();
    private final ConfluentMetric.YammerMeter.Builder meterBuilder = ConfluentMetric.YammerMeter.newBuilder();
    private final ConfluentMetric.YammerHistogram.Builder histogramBuilder = ConfluentMetric.YammerHistogram.newBuilder();
    private final ConfluentMetric.YammerTimer.Builder timerBuilder = ConfluentMetric.YammerTimer.newBuilder();
    private final ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();

    private long delta(MetricName metric, long count) {
        String name = metric.getMBeanName();
        this.counters.putIfAbsent(name, new AtomicLong(count));
        return count - ((AtomicLong)this.counters.get(name)).getAndSet(count);
    }

    public YammerMetricsResult collectYammerMetrics(MetricsRegistry metricsRegistry, Pattern pattern) {
        Set metrics = metricsRegistry.allMetrics().entrySet();
        ArrayList<ConfluentMetric.YammerGauge> yammerGauges = new ArrayList<ConfluentMetric.YammerGauge>();
        ArrayList<ConfluentMetric.YammerMeter> yammerMeters = new ArrayList<ConfluentMetric.YammerMeter>();
        ArrayList<ConfluentMetric.YammerHistogram> yammerHistograms = new ArrayList<ConfluentMetric.YammerHistogram>();
        ArrayList<ConfluentMetric.YammerTimer> yammerTimers = new ArrayList<ConfluentMetric.YammerTimer>();
        for (Map.Entry entry : metrics) {
            MetricName metricName = (MetricName)entry.getKey();
            if (pattern != null && !pattern.matcher(metricName.getMBeanName()).matches()) continue;
            try {
                this.metricNameBuilder.clear();
                this.metricNameBuilder.setGroup(Utils.notNullOrEmpty(metricName.getGroup()));
                this.metricNameBuilder.setName(Utils.notNullOrEmpty(metricName.getName()));
                this.metricNameBuilder.setType(Utils.notNullOrEmpty(metricName.getType()));
                this.metricNameBuilder.setScope(Utils.notNullOrEmpty(metricName.getScope()));
                this.metricNameBuilder.setMBeanName(Utils.notNullOrEmpty(metricName.getMBeanName()));
                Metric metric = (Metric)entry.getValue();
                if (metric instanceof Gauge) {
                    yammerGauges.add(this.handleGauge((Gauge)metric));
                    continue;
                }
                if (metric instanceof Meter) {
                    yammerMeters.add(this.handleMeter(metricName, (Meter)metric));
                    continue;
                }
                if (metric instanceof Histogram) {
                    yammerHistograms.add(this.handleHistogram(metricName, (Histogram)metric));
                    continue;
                }
                if (!(metric instanceof Timer)) continue;
                yammerTimers.add(this.handleTimer(metricName, (Timer)metric));
            }
            catch (Exception e) {
                log.warn("Unexpected error in processing Yammer metric {}", (Object)metricName, (Object)e);
            }
        }
        return new YammerMetricsResult(yammerGauges, yammerMeters, yammerHistograms, yammerTimers);
    }

    private ConfluentMetric.YammerTimer handleTimer(MetricName metricName, Timer metric) {
        Timer timer = metric;
        this.timerBuilder.clear();
        this.timerBuilder.setMetricName(this.metricNameBuilder.build());
        long count = timer.count();
        this.timerBuilder.setCount(count);
        this.timerBuilder.setDeltaCount(this.delta(metricName, count));
        this.timerBuilder.setMax(timer.max());
        this.timerBuilder.setMin(timer.min());
        this.timerBuilder.setMean(timer.mean());
        this.timerBuilder.setStdDev(timer.stdDev());
        this.timerBuilder.setSum(timer.sum());
        Snapshot snapshot = timer.getSnapshot();
        this.timerBuilder.setMedian(snapshot.getMedian());
        this.timerBuilder.setPercentile75Th(snapshot.get75thPercentile());
        this.timerBuilder.setPercentile95Th(snapshot.get95thPercentile());
        this.timerBuilder.setPercentile98Th(snapshot.get98thPercentile());
        this.timerBuilder.setPercentile99Th(snapshot.get99thPercentile());
        this.timerBuilder.setPercentile999Th(snapshot.get999thPercentile());
        this.timerBuilder.setSize(snapshot.size());
        this.timerBuilder.setOneMinuteRate(timer.oneMinuteRate());
        this.timerBuilder.setFiveMinuteRate(timer.fiveMinuteRate());
        this.timerBuilder.setFifteenMinuteRate(timer.fifteenMinuteRate());
        this.timerBuilder.setMeanRate(timer.meanRate());
        return this.timerBuilder.build();
    }

    private ConfluentMetric.YammerHistogram handleHistogram(MetricName metricName, Histogram metric) {
        Histogram histogram = metric;
        this.histogramBuilder.clear();
        this.histogramBuilder.setMetricName(this.metricNameBuilder.build());
        long count = histogram.count();
        this.histogramBuilder.setCount(count);
        this.histogramBuilder.setDeltaCount(this.delta(metricName, count));
        this.histogramBuilder.setMax(histogram.max());
        this.histogramBuilder.setMin(histogram.min());
        this.histogramBuilder.setMean(histogram.mean());
        this.histogramBuilder.setStdDev(histogram.stdDev());
        this.histogramBuilder.setSum(histogram.sum());
        Snapshot snapshot = histogram.getSnapshot();
        this.histogramBuilder.setMedian(snapshot.getMedian());
        this.histogramBuilder.setPercentile75Th(snapshot.get75thPercentile());
        this.histogramBuilder.setPercentile95Th(snapshot.get95thPercentile());
        this.histogramBuilder.setPercentile98Th(snapshot.get98thPercentile());
        this.histogramBuilder.setPercentile99Th(snapshot.get99thPercentile());
        this.histogramBuilder.setPercentile999Th(snapshot.get999thPercentile());
        this.histogramBuilder.setSize(snapshot.size());
        return this.histogramBuilder.build();
    }

    private ConfluentMetric.YammerMeter handleMeter(MetricName metricName, Meter metric) {
        Meter meter = metric;
        this.meterBuilder.clear();
        this.meterBuilder.setMetricName(this.metricNameBuilder.build());
        long count = meter.count();
        this.meterBuilder.setCount(count);
        this.meterBuilder.setDeltaCount(this.delta(metricName, count));
        this.meterBuilder.setOneMinuteRate(meter.oneMinuteRate());
        this.meterBuilder.setFiveMinuteRate(meter.fiveMinuteRate());
        this.meterBuilder.setFifteenMinuteRate(meter.fifteenMinuteRate());
        this.meterBuilder.setMeanRate(meter.meanRate());
        return this.meterBuilder.build();
    }

    private ConfluentMetric.YammerGauge handleGauge(Gauge metric) {
        Gauge gauge = metric;
        this.gaugeBuilder.clear();
        this.gaugeBuilder.setMetricName(this.metricNameBuilder.build());
        Object value = gauge.value();
        this.gaugeBuilder.setValue(value == null ? "" : value.toString());
        if (value instanceof Integer || value instanceof Long) {
            this.gaugeBuilder.setLongValue(((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            this.gaugeBuilder.setDoubleValue(((Number)value).doubleValue());
        }
        return this.gaugeBuilder.build();
    }

    public static class YammerMetricsResult {
        public final List<ConfluentMetric.YammerGauge> gauges;
        public final List<ConfluentMetric.YammerMeter> meters;
        public final List<ConfluentMetric.YammerHistogram> histograms;
        public final List<ConfluentMetric.YammerTimer> timers;

        public YammerMetricsResult(List<ConfluentMetric.YammerGauge> gauges, List<ConfluentMetric.YammerMeter> meters, List<ConfluentMetric.YammerHistogram> histograms, List<ConfluentMetric.YammerTimer> timers) {
            this.gauges = gauges;
            this.meters = meters;
            this.histograms = histograms;
            this.timers = timers;
        }
    }
}

