/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.com.fasterxml.jackson.databind.cfg;

import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import io.confluent.shaded.com.fasterxml.jackson.databind.JavaType;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.confluent.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import io.confluent.shaded.com.fasterxml.jackson.databind.cfg.CacheProvider;
import io.confluent.shaded.com.fasterxml.jackson.databind.util.LRUMap;
import io.confluent.shaded.com.fasterxml.jackson.databind.util.LookupCache;
import io.confluent.shaded.com.fasterxml.jackson.databind.util.TypeKey;

public class DefaultCacheProvider
implements CacheProvider {
    private static final long serialVersionUID = 1L;
    private static final DefaultCacheProvider DEFAULT = new DefaultCacheProvider(2000, 4000, 200);
    protected final int _maxDeserializerCacheSize;
    protected final int _maxSerializerCacheSize;
    protected final int _maxTypeFactoryCacheSize;

    protected DefaultCacheProvider(int maxDeserializerCacheSize, int maxSerializerCacheSize, int maxTypeFactoryCacheSize) {
        this._maxDeserializerCacheSize = maxDeserializerCacheSize;
        this._maxSerializerCacheSize = maxSerializerCacheSize;
        this._maxTypeFactoryCacheSize = maxTypeFactoryCacheSize;
    }

    public static CacheProvider defaultInstance() {
        return DEFAULT;
    }

    @Override
    public LookupCache<JavaType, JsonDeserializer<Object>> forDeserializerCache(DeserializationConfig config) {
        return this._buildCache(this._maxDeserializerCacheSize);
    }

    @Override
    public LookupCache<TypeKey, JsonSerializer<Object>> forSerializerCache(SerializationConfig config) {
        return this._buildCache(this._maxSerializerCacheSize);
    }

    @Override
    public LookupCache<Object, JavaType> forTypeFactory() {
        return this._buildCache(this._maxTypeFactoryCacheSize);
    }

    protected <K, V> LookupCache<K, V> _buildCache(int maxSize) {
        int initialSize = Math.min(64, maxSize >> 2);
        return new LRUMap(initialSize, maxSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int _maxDeserializerCacheSize;
        private int _maxSerializerCacheSize;
        private int _maxTypeFactoryCacheSize;

        Builder() {
        }

        public Builder maxDeserializerCacheSize(int maxDeserializerCacheSize) {
            if (maxDeserializerCacheSize < 0) {
                throw new IllegalArgumentException("Cannot set maxDeserializerCacheSize to a negative value");
            }
            this._maxDeserializerCacheSize = maxDeserializerCacheSize;
            return this;
        }

        public Builder maxSerializerCacheSize(int maxSerializerCacheSize) {
            if (maxSerializerCacheSize < 0) {
                throw new IllegalArgumentException("Cannot set maxSerializerCacheSize to a negative value");
            }
            this._maxSerializerCacheSize = maxSerializerCacheSize;
            return this;
        }

        public Builder maxTypeFactoryCacheSize(int maxTypeFactoryCacheSize) {
            if (maxTypeFactoryCacheSize < 0) {
                throw new IllegalArgumentException("Cannot set maxTypeFactoryCacheSize to a negative value");
            }
            this._maxTypeFactoryCacheSize = maxTypeFactoryCacheSize;
            return this;
        }

        public DefaultCacheProvider build() {
            return new DefaultCacheProvider(this._maxDeserializerCacheSize, this._maxSerializerCacheSize, this._maxTypeFactoryCacheSize);
        }
    }
}

