/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.com.fasterxml.jackson.databind.ser.std;

import io.confluent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.confluent.shaded.com.fasterxml.jackson.core.JsonToken;
import io.confluent.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import io.confluent.shaded.com.fasterxml.jackson.databind.JavaType;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.confluent.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.confluent.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.confluent.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.confluent.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

