/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents;

import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ParametersAreNonnullByDefault
public enum SpecVersion {
    V03("0.3", Arrays.asList("specversion", "id", "type", "source"), Arrays.asList("datacontenttype", "datacontentencoding", "schemaurl", "subject", "time")),
    V1("1.0", Arrays.asList("specversion", "id", "type", "source"), Arrays.asList("datacontenttype", "dataschema", "subject", "time"));

    private final String stringValue;
    private final Set<String> mandatoryAttributes;
    private final Set<String> optionalAttributes;
    private final Set<String> allAttributes;

    private SpecVersion(String stringValue, Collection<String> mandatoryAttributes, Collection<String> optionalAttributes) {
        this.stringValue = stringValue;
        this.mandatoryAttributes = Collections.unmodifiableSet(new HashSet<String>(mandatoryAttributes));
        this.optionalAttributes = Collections.unmodifiableSet(new HashSet<String>(optionalAttributes));
        this.allAttributes = Collections.unmodifiableSet(Stream.concat(mandatoryAttributes.stream(), optionalAttributes.stream()).collect(Collectors.toSet()));
    }

    public String toString() {
        return this.stringValue;
    }

    public static SpecVersion parse(String sv) {
        switch (sv) {
            case "0.3": {
                return V03;
            }
            case "1.0": {
                return V1;
            }
        }
        throw CloudEventRWException.newInvalidSpecVersion(sv);
    }

    public Set<String> getMandatoryAttributes() {
        return this.mandatoryAttributes;
    }

    public Set<String> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<String> getAllAttributes() {
        return this.allAttributes;
    }
}

