/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.core.extensions;

import io.confluent.shaded.io.cloudevents.CloudEventExtension;
import io.confluent.shaded.io.cloudevents.CloudEventExtensions;
import io.confluent.shaded.io.cloudevents.core.extensions.impl.ExtensionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class DistributedTracingExtension
implements CloudEventExtension {
    public static final String TRACEPARENT = "traceparent";
    public static final String TRACESTATE = "tracestate";
    private static final Set<String> KEY_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("traceparent", "tracestate")));
    private String traceparent;
    private String tracestate;

    public String getTraceparent() {
        return this.traceparent;
    }

    public void setTraceparent(String traceparent) {
        this.traceparent = traceparent;
    }

    public String getTracestate() {
        return this.tracestate;
    }

    public void setTracestate(String tracestate) {
        this.tracestate = tracestate;
    }

    @Override
    public void readFrom(CloudEventExtensions extensions) {
        Object ts;
        Object tp = extensions.getExtension(TRACEPARENT);
        if (tp != null) {
            this.traceparent = tp.toString();
        }
        if ((ts = extensions.getExtension(TRACESTATE)) != null) {
            this.tracestate = ts.toString();
        }
    }

    @Override
    public Object getValue(String key) {
        switch (key) {
            case "traceparent": {
                return this.traceparent;
            }
            case "tracestate": {
                return this.tracestate;
            }
        }
        throw ExtensionUtils.generateInvalidKeyException(this.getClass(), key);
    }

    @Override
    public Set<String> getKeys() {
        return KEY_SET;
    }

    public String toString() {
        return "DistributedTracingExtension{traceparent='" + this.traceparent + '\'' + ", tracestate='" + this.tracestate + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedTracingExtension that = (DistributedTracingExtension)o;
        return Objects.equals(this.getTraceparent(), that.getTraceparent()) && Objects.equals(this.getTracestate(), that.getTracestate());
    }

    public int hashCode() {
        return Objects.hash(this.getTraceparent(), this.getTracestate());
    }
}

