/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.core.message.impl;

import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.SpecVersion;
import io.confluent.shaded.io.cloudevents.core.message.impl.BaseBinaryMessageReader;
import io.confluent.shaded.io.cloudevents.rw.CloudEventDataMapper;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriter;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriterFactory;
import java.util.Objects;
import java.util.function.BiConsumer;

public abstract class BaseGenericBinaryMessageReaderImpl<HK, HV>
extends BaseBinaryMessageReader {
    private final SpecVersion version;
    private final CloudEventData body;

    protected BaseGenericBinaryMessageReaderImpl(SpecVersion version, CloudEventData body) {
        Objects.requireNonNull(version);
        this.version = version;
        this.body = body;
    }

    public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException, IllegalStateException {
        Object visitor = writerFactory.create(this.version);
        this.forEachHeader((key, value) -> {
            if (value == null) {
                return;
            }
            if (this.isContentTypeHeader(key)) {
                visitor.withContextAttribute("datacontenttype", this.toCloudEventsValue(value));
            } else if (this.isCloudEventsHeader(key)) {
                String name = this.toCloudEventsKey(key);
                if (name.equals("specversion")) {
                    return;
                }
                visitor.withContextAttribute(name, this.toCloudEventsValue(value));
            }
        });
        if (this.body != null) {
            return visitor.end(mapper.map(this.body));
        }
        return visitor.end();
    }

    protected abstract boolean isContentTypeHeader(HK var1);

    protected abstract boolean isCloudEventsHeader(HK var1);

    protected abstract String toCloudEventsKey(HK var1);

    protected abstract void forEachHeader(BiConsumer<HK, HV> var1);

    protected abstract String toCloudEventsValue(HV var1);
}

