/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.core.provider;

import io.confluent.shaded.io.cloudevents.CloudEventExtension;
import io.confluent.shaded.io.cloudevents.CloudEventExtensions;
import io.confluent.shaded.io.cloudevents.core.extensions.DatarefExtension;
import io.confluent.shaded.io.cloudevents.core.extensions.DistributedTracingExtension;
import io.confluent.shaded.io.cloudevents.lang.Nullable;
import io.confluent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import java.util.HashMap;
import java.util.function.Supplier;

@ParametersAreNonnullByDefault
public final class ExtensionProvider {
    private final HashMap<Class<?>, Supplier<?>> extensionFactories = new HashMap();

    public static ExtensionProvider getInstance() {
        return SingletonContainer.INSTANCE;
    }

    private ExtensionProvider() {
        this.registerExtension(DistributedTracingExtension.class, DistributedTracingExtension::new);
        this.registerExtension(DatarefExtension.class, DatarefExtension::new);
    }

    public <T extends CloudEventExtension> void registerExtension(Class<T> extensionClass, Supplier<T> factory) {
        this.extensionFactories.put(extensionClass, factory);
    }

    @Nullable
    public <T extends CloudEventExtension> T parseExtension(Class<T> extensionClass, CloudEventExtensions eventExtensions) {
        Supplier<?> factory = this.extensionFactories.get(extensionClass);
        if (factory != null) {
            CloudEventExtension ext = (CloudEventExtension)factory.get();
            ext.readFrom(eventExtensions);
            return (T)ext;
        }
        return null;
    }

    private static class SingletonContainer {
        private static final ExtensionProvider INSTANCE = new ExtensionProvider();

        private SingletonContainer() {
        }
    }
}

