/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.jackson;

import io.confluent.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.confluent.shaded.io.cloudevents.CloudEventData;
import java.util.Objects;

public class JsonCloudEventData
implements CloudEventData {
    private final JsonNode node;

    public JsonCloudEventData(JsonNode node) {
        Objects.requireNonNull(node);
        this.node = node;
    }

    @Override
    public byte[] toBytes() {
        return this.node.toString().getBytes();
    }

    public JsonNode getNode() {
        return this.node;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonCloudEventData that = (JsonCloudEventData)o;
        return Objects.equals(this.getNode(), that.getNode());
    }

    public int hashCode() {
        return Objects.hash(this.getNode());
    }

    public String toString() {
        return "JsonCloudEventData{node=" + this.node + '}';
    }

    public static JsonCloudEventData wrap(JsonNode node) {
        return new JsonCloudEventData(node);
    }
}

