/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.jackson;

import io.confluent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.core.builder.CloudEventBuilder;
import io.confluent.shaded.io.cloudevents.core.format.EventDeserializationException;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.format.EventSerializationException;
import io.confluent.shaded.io.cloudevents.jackson.CloudEventDeserializer;
import io.confluent.shaded.io.cloudevents.jackson.CloudEventSerializer;
import io.confluent.shaded.io.cloudevents.jackson.JsonFormatOptions;
import io.confluent.shaded.io.cloudevents.rw.CloudEventDataMapper;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import java.io.IOException;

public final class JsonFormat
implements EventFormat {
    public static final String CONTENT_TYPE = "application/cloudevents+json";
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonFormatOptions options;

    public JsonFormat(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        this(JsonFormatOptions.builder().forceDataBase64Serialization(forceDataBase64Serialization).forceStringSerialization(forceStringSerialization).build());
    }

    public JsonFormat(JsonFormatOptions options) {
        this.mapper.registerModule(JsonFormat.getCloudEventJacksonModule(options));
        this.options = options;
    }

    public JsonFormat() {
        this(new JsonFormatOptions());
    }

    public JsonFormat withForceJsonDataToBase64() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(true).forceStringSerialization(this.options.isForceStringSerialization()).forceExtensionNameLowerCaseDeserialization(this.options.isForceExtensionNameLowerCaseDeserialization()).forceIgnoreInvalidExtensionNameDeserialization(this.options.isForceIgnoreInvalidExtensionNameDeserialization()).build());
    }

    public JsonFormat withForceNonJsonDataToString() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(this.options.isForceDataBase64Serialization()).forceStringSerialization(true).forceExtensionNameLowerCaseDeserialization(this.options.isForceExtensionNameLowerCaseDeserialization()).forceIgnoreInvalidExtensionNameDeserialization(this.options.isForceIgnoreInvalidExtensionNameDeserialization()).build());
    }

    public JsonFormat withForceExtensionNameLowerCaseDeserialization() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(this.options.isForceDataBase64Serialization()).forceStringSerialization(this.options.isForceStringSerialization()).forceExtensionNameLowerCaseDeserialization(true).forceIgnoreInvalidExtensionNameDeserialization(this.options.isForceIgnoreInvalidExtensionNameDeserialization()).build());
    }

    public JsonFormat withForceIgnoreInvalidExtensionNameDeserialization() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(this.options.isForceDataBase64Serialization()).forceStringSerialization(this.options.isForceStringSerialization()).forceExtensionNameLowerCaseDeserialization(this.options.isForceExtensionNameLowerCaseDeserialization()).forceIgnoreInvalidExtensionNameDeserialization(true).build());
    }

    @Override
    public byte[] serialize(CloudEvent event) throws EventSerializationException {
        try {
            return this.mapper.writeValueAsBytes(event);
        }
        catch (JsonProcessingException e) {
            throw new EventSerializationException(e);
        }
    }

    @Override
    public CloudEvent deserialize(byte[] bytes) throws EventDeserializationException {
        try {
            return this.mapper.readValue(bytes, CloudEvent.class);
        }
        catch (IOException e) {
            throw new EventDeserializationException(e);
        }
    }

    @Override
    public CloudEvent deserialize(byte[] bytes, CloudEventDataMapper<? extends CloudEventData> mapper) throws EventDeserializationException {
        CloudEvent deserialized = this.deserialize(bytes);
        if (deserialized.getData() == null) {
            return deserialized;
        }
        try {
            return CloudEventBuilder.from(deserialized).withData(mapper.map(deserialized.getData())).build();
        }
        catch (CloudEventRWException e) {
            throw new EventDeserializationException(e);
        }
    }

    @Override
    public String serializedContentType() {
        return CONTENT_TYPE;
    }

    public static SimpleModule getCloudEventJacksonModule() {
        return JsonFormat.getCloudEventJacksonModule(false, false);
    }

    public static SimpleModule getCloudEventJacksonModule(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        return JsonFormat.getCloudEventJacksonModule(JsonFormatOptions.builder().forceDataBase64Serialization(forceDataBase64Serialization).forceStringSerialization(forceStringSerialization).build());
    }

    public static SimpleModule getCloudEventJacksonModule(JsonFormatOptions options) {
        SimpleModule ceModule = new SimpleModule("CloudEvent");
        ceModule.addSerializer(CloudEvent.class, new CloudEventSerializer(options.isForceDataBase64Serialization(), options.isForceStringSerialization()));
        ceModule.addDeserializer(CloudEvent.class, new CloudEventDeserializer(options.isForceExtensionNameLowerCaseDeserialization(), options.isForceIgnoreInvalidExtensionNameDeserialization()));
        return ceModule;
    }

    static boolean dataIsJsonContentType(String contentType) {
        return contentType == null || contentType.startsWith("application/json") || contentType.startsWith("text/json");
    }
}

