/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.jackson;

import io.confluent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.shaded.com.fasterxml.jackson.databind.JavaType;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.confluent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.core.data.PojoCloudEventData;
import io.confluent.shaded.io.cloudevents.jackson.JsonCloudEventData;
import io.confluent.shaded.io.cloudevents.rw.CloudEventDataMapper;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;

public class PojoCloudEventDataMapper<T>
implements CloudEventDataMapper<PojoCloudEventData<T>> {
    private final ObjectMapper mapper;
    private final JavaType target;

    private PojoCloudEventDataMapper(ObjectMapper mapper, JavaType target) {
        this.mapper = mapper;
        this.target = target;
    }

    @Override
    public PojoCloudEventData<T> map(CloudEventData data) throws CloudEventRWException {
        Object value;
        if (data instanceof JsonCloudEventData) {
            Object value2;
            JsonNode node = ((JsonCloudEventData)data).getNode();
            try {
                value2 = this.mapper.convertValue((Object)node, this.target);
            }
            catch (Exception e) {
                throw CloudEventRWException.newDataConversion(e, JsonNode.class.toString(), this.target.getTypeName());
            }
            return PojoCloudEventData.wrap(value2, this.mapper::writeValueAsBytes);
        }
        byte[] bytes = data.toBytes();
        try {
            value = this.mapper.readValue(bytes, this.target);
        }
        catch (Exception e) {
            throw CloudEventRWException.newDataConversion(e, byte[].class.toString(), this.target.getTypeName());
        }
        return PojoCloudEventData.wrap(value, v -> bytes);
    }

    public static <T> PojoCloudEventDataMapper<T> from(ObjectMapper mapper, Class<T> target) {
        return new PojoCloudEventDataMapper<T>(mapper, mapper.getTypeFactory().constructType(target));
    }

    public static <T> PojoCloudEventDataMapper<T> from(ObjectMapper mapper, TypeReference<T> target) {
        return new PojoCloudEventDataMapper<T>(mapper, mapper.getTypeFactory().constructType(target));
    }
}

