/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.kafka;

import io.confluent.shaded.io.cloudevents.SpecVersion;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.message.MessageReader;
import io.confluent.shaded.io.cloudevents.core.message.MessageWriter;
import io.confluent.shaded.io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.confluent.shaded.io.cloudevents.core.message.impl.MessageUtils;
import io.confluent.shaded.io.cloudevents.kafka.impl.KafkaBinaryMessageReaderImpl;
import io.confluent.shaded.io.cloudevents.kafka.impl.KafkaHeaders;
import io.confluent.shaded.io.cloudevents.kafka.impl.KafkaProducerMessageWriterImpl;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriter;
import io.confluent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;

@ParametersAreNonnullByDefault
public final class KafkaMessageFactory {
    private KafkaMessageFactory() {
    }

    public static <K> MessageReader createReader(ConsumerRecord<K, byte[]> record) throws CloudEventRWException {
        return KafkaMessageFactory.createReader(record.headers(), (byte[])record.value());
    }

    public static MessageReader createReader(Headers headers, byte[] payload) throws CloudEventRWException {
        return MessageUtils.parseStructuredOrBinaryMessage(() -> KafkaHeaders.getParsedKafkaHeader(headers, "content-type"), format -> new GenericStructuredMessageReader((EventFormat)format, payload), () -> KafkaHeaders.getParsedKafkaHeader(headers, KafkaHeaders.SPEC_VERSION), sv -> new KafkaBinaryMessageReaderImpl((SpecVersion)((Object)sv), headers, payload));
    }

    public static <K> MessageWriter<CloudEventWriter<ProducerRecord<K, byte[]>>, ProducerRecord<K, byte[]>> createWriter(String topic, Integer partition, Long timestamp, K key) {
        return new KafkaProducerMessageWriterImpl<K>(topic, partition, timestamp, key);
    }

    public static <K> MessageWriter<CloudEventWriter<ProducerRecord<K, byte[]>>, ProducerRecord<K, byte[]>> createWriter(String topic, Integer partition, K key) {
        return KafkaMessageFactory.createWriter(topic, partition, null, key);
    }

    public static <K> MessageWriter<CloudEventWriter<ProducerRecord<K, byte[]>>, ProducerRecord<K, byte[]>> createWriter(String topic, K key) {
        return KafkaMessageFactory.createWriter(topic, null, null, key);
    }

    public static MessageWriter<CloudEventWriter<ProducerRecord<Void, byte[]>>, ProducerRecord<Void, byte[]>> createWriter(String topic) {
        return KafkaMessageFactory.createWriter(topic, null, null, null);
    }
}

