/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.kafka.impl;

import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.message.MessageWriter;
import io.confluent.shaded.io.cloudevents.kafka.impl.KafkaHeaders;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriter;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;

abstract class BaseKafkaMessageWriterImpl<R>
implements MessageWriter<CloudEventWriter<R>, R>,
CloudEventWriter<R> {
    final Headers headers;
    byte[] value;

    public BaseKafkaMessageWriterImpl(Headers headers) {
        this.headers = headers;
    }

    @Override
    public BaseKafkaMessageWriterImpl<R> withContextAttribute(String name, String value) throws CloudEventRWException {
        String headerName = KafkaHeaders.ATTRIBUTES_TO_HEADERS.get(name);
        if (headerName == null) {
            headerName = "ce_" + name;
        }
        this.headers.add((Header)new RecordHeader(headerName, value.getBytes()));
        return this;
    }

    @Override
    public R end(CloudEventData value) throws CloudEventRWException {
        this.value = value.toBytes();
        return this.end();
    }

    @Override
    public R setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.headers.add((Header)new RecordHeader("content-type", format.serializedContentType().getBytes()));
        this.value = value;
        return this.end();
    }
}

