/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.protobuf;

import io.confluent.shaded.com.google.protobuf.Message;
import io.confluent.shaded.com.google.protobuf.Timestamp;
import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.SpecVersion;
import io.confluent.shaded.io.cloudevents.core.data.BytesCloudEventData;
import io.confluent.shaded.io.cloudevents.protobuf.ProtoCloudEventData;
import io.confluent.shaded.io.cloudevents.rw.CloudEventDataMapper;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.io.cloudevents.rw.CloudEventReader;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriter;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriterFactory;
import io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

class ProtoDeserializer
implements CloudEventReader {
    private final CloudEvent protoCe;

    public ProtoDeserializer(CloudEvent protoCe) {
        this.protoCe = protoCe;
    }

    @Override
    public <W extends CloudEventWriter<R>, R> R read(CloudEventWriterFactory<W, R> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException {
        SpecVersion specVersion = SpecVersion.parse(this.protoCe.getSpecVersion());
        W writer = writerFactory.create(specVersion);
        writer.withContextAttribute("id", this.protoCe.getId());
        writer.withContextAttribute("source", this.protoCe.getSource());
        writer.withContextAttribute("type", this.protoCe.getType());
        for (Map.Entry<String, CloudEvent.CloudEventAttributeValue> entry : this.protoCe.getAttributesMap().entrySet()) {
            String name = entry.getKey();
            CloudEvent.CloudEventAttributeValue val = entry.getValue();
            switch (val.getAttrCase()) {
                case CE_BOOLEAN: {
                    writer.withContextAttribute(name, val.getCeBoolean());
                    break;
                }
                case CE_INTEGER: {
                    writer.withContextAttribute(name, val.getCeInteger());
                    break;
                }
                case CE_STRING: {
                    writer.withContextAttribute(name, val.getCeString());
                    break;
                }
                case CE_BYTES: {
                    writer.withContextAttribute(name, val.getCeBytes().toByteArray());
                    break;
                }
                case CE_URI: {
                    writer.withContextAttribute(name, URI.create(val.getCeUri()));
                    break;
                }
                case CE_URI_REF: {
                    writer.withContextAttribute(name, URI.create(val.getCeUriRef()));
                    break;
                }
                case CE_TIMESTAMP: {
                    Timestamp timestamp = val.getCeTimestamp();
                    writer.withContextAttribute(name, this.covertProtoTimestamp(timestamp));
                    break;
                }
            }
        }
        CloudEventData data = null;
        byte[] raw = null;
        switch (this.protoCe.getDataCase()) {
            case BINARY_DATA: {
                raw = this.protoCe.getBinaryData().toByteArray();
                data = BytesCloudEventData.wrap(raw);
                break;
            }
            case TEXT_DATA: {
                raw = this.protoCe.getTextData().getBytes(StandardCharsets.UTF_8);
                data = BytesCloudEventData.wrap(raw);
                break;
            }
            case PROTO_DATA: {
                data = new ProtoAccessor(this.protoCe);
                break;
            }
        }
        if (data != null) {
            return writer.end(mapper.map(data));
        }
        return writer.end();
    }

    private OffsetDateTime covertProtoTimestamp(Timestamp timestamp) {
        Instant instant = Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        return instant.atOffset(ZoneOffset.UTC);
    }

    private static class ProtoAccessor
    implements ProtoCloudEventData {
        private final Message message;

        ProtoAccessor(CloudEvent proto) {
            this.message = proto.getProtoData();
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public byte[] toBytes() {
            return this.message.toByteArray();
        }
    }
}

