/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.protobuf;

import io.confluent.shaded.com.google.protobuf.Any;
import io.confluent.shaded.com.google.protobuf.ByteString;
import io.confluent.shaded.com.google.protobuf.Descriptors;
import io.confluent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.shaded.com.google.protobuf.Timestamp;
import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.SpecVersion;
import io.confluent.shaded.io.cloudevents.core.CloudEventUtils;
import io.confluent.shaded.io.cloudevents.protobuf.ProtoCloudEventData;
import io.confluent.shaded.io.cloudevents.rw.CloudEventContextReader;
import io.confluent.shaded.io.cloudevents.rw.CloudEventContextWriter;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriter;
import io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent;
import java.net.URI;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class ProtoSerializer {
    ProtoSerializer() {
    }

    public static io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent toProto(CloudEvent ce) throws InvalidProtocolBufferException {
        CloudEvent.Builder builder = io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent.newBuilder();
        builder.setSpecVersion(ce.getSpecVersion().toString());
        ProtoCloudEventWriter protoCloudEventWriter = new ProtoCloudEventWriter(builder, ce.getSpecVersion());
        CloudEventContextReader cloudEventContextReader = CloudEventUtils.toContextReader(ce);
        cloudEventContextReader.readContext(protoCloudEventWriter);
        CloudEventData data = ce.getData();
        if (data != null) {
            return protoCloudEventWriter.end(data);
        }
        return protoCloudEventWriter.end();
    }

    private static boolean isTextType(String type) {
        if (type == null) {
            return false;
        }
        return type.startsWith("text/") || "application/json".equals(type) || "application/xml".equals(type);
    }

    public static class ProtoCloudEventWriter
    implements CloudEventWriter<io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent> {
        private static final Map<String, Descriptors.FieldDescriptor> attributeToFieldNumV1;
        private static final Map<SpecVersion, Map<String, Descriptors.FieldDescriptor>> versionToAttrs;
        private final CloudEvent.Builder protoBuilder;
        private final Map<String, Descriptors.FieldDescriptor> requiredAttributeNumberMap;

        public ProtoCloudEventWriter(CloudEvent.Builder protoBuilder, SpecVersion spec) {
            this.protoBuilder = protoBuilder;
            this.requiredAttributeNumberMap = versionToAttrs.get((Object)spec);
            if (this.requiredAttributeNumberMap == null) {
                throw CloudEventRWException.newInvalidSpecVersion(spec.toString());
            }
        }

        private boolean setRequiredField(String name, Object value) {
            Descriptors.FieldDescriptor fieldDescriptor = this.requiredAttributeNumberMap.get(name);
            if (fieldDescriptor == null) {
                return false;
            }
            this.protoBuilder.setField(fieldDescriptor, value);
            return true;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                this.protoBuilder.putAttributes(name, CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(value).build());
            }
            return this;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name, URI value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value.toString())) {
                CloudEvent.CloudEventAttributeValue.Builder builder = CloudEvent.CloudEventAttributeValue.newBuilder();
                if (value.isAbsolute()) {
                    this.protoBuilder.putAttributes(name, builder.setCeUri(value.toString()).build());
                } else {
                    this.protoBuilder.putAttributes(name, builder.setCeUriRef(value.toString()).build());
                }
            }
            return this;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
            Instant instant = value.toInstant();
            Timestamp ts = Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
            if (!this.setRequiredField(name, ts)) {
                this.protoBuilder.putAttributes(name, CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(ts).build());
            }
            return this;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name, Number value) throws CloudEventRWException {
            if (value instanceof Integer) {
                return this.withContextAttribute(name, (Integer)value);
            }
            return this.withContextAttribute(name, value.toString());
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name, Boolean value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                this.protoBuilder.putAttributes(name, CloudEvent.CloudEventAttributeValue.newBuilder().setCeBoolean(value).build());
            }
            return this;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name, byte[] value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                CloudEvent.CloudEventAttributeValue.Builder builder = CloudEvent.CloudEventAttributeValue.newBuilder().setCeBytes(ByteString.copyFrom(value));
                this.protoBuilder.putAttributes(name, builder.build());
            }
            return this;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name, Integer value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                CloudEvent.CloudEventAttributeValue.Builder builder = CloudEvent.CloudEventAttributeValue.newBuilder();
                builder.setCeInteger(value);
                this.protoBuilder.putAttributes(name, builder.build());
            }
            return this;
        }

        @Override
        public io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent end(CloudEventData data) throws CloudEventRWException {
            if (data != null) {
                String dataContentType = null;
                Map<String, CloudEvent.CloudEventAttributeValue> attributesMap = this.protoBuilder.getAttributesMap();
                CloudEvent.CloudEventAttributeValue attrVal = attributesMap.get("datacontenttype");
                if (attrVal != null && attrVal.hasCeString()) {
                    dataContentType = attrVal.getCeString();
                }
                if (data instanceof ProtoCloudEventData) {
                    ProtoCloudEventData protoData = (ProtoCloudEventData)data;
                    if (protoData.getMessage() != null) {
                        this.protoBuilder.setProtoData(Any.pack(protoData.getMessage()));
                    }
                } else if (Objects.equals(dataContentType, "application/protobuf")) {
                    Any dataAsAny = null;
                    try {
                        dataAsAny = Any.parseFrom(data.toBytes());
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw CloudEventRWException.newDataConversion(e, "byte[]", "io.confluent.shaded.com.google.protobuf.Any");
                    }
                    this.protoBuilder.setProtoData(dataAsAny);
                } else if (ProtoSerializer.isTextType(dataContentType)) {
                    this.protoBuilder.setTextDataBytes(ByteString.copyFrom(data.toBytes()));
                } else {
                    ByteString byteString = ByteString.copyFrom(data.toBytes());
                    this.protoBuilder.setBinaryData(byteString);
                }
            }
            return this.protoBuilder.build();
        }

        @Override
        public io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent end() throws CloudEventRWException {
            return this.protoBuilder.build();
        }

        static {
            HashMap<String, Descriptors.FieldDescriptor> tmp = new HashMap<String, Descriptors.FieldDescriptor>();
            tmp.put("id", io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(1));
            tmp.put("source", io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(2));
            tmp.put("type", io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(4));
            tmp.put("specversion", io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(3));
            attributeToFieldNumV1 = Collections.unmodifiableMap(tmp);
            HashMap<SpecVersion, Map<String, Descriptors.FieldDescriptor>> tmpMap = new HashMap<SpecVersion, Map<String, Descriptors.FieldDescriptor>>();
            tmpMap.put(SpecVersion.V1, attributeToFieldNumV1);
            tmpMap.put(SpecVersion.V03, attributeToFieldNumV1);
            versionToAttrs = Collections.unmodifiableMap(tmpMap);
        }
    }
}

