/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.protobuf;

import io.confluent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.core.builder.CloudEventBuilder;
import io.confluent.shaded.io.cloudevents.core.format.EventDeserializationException;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.format.EventSerializationException;
import io.confluent.shaded.io.cloudevents.protobuf.ProtoDeserializer;
import io.confluent.shaded.io.cloudevents.protobuf.ProtoSerializer;
import io.confluent.shaded.io.cloudevents.rw.CloudEventDataMapper;

public class ProtobufFormat
implements EventFormat {
    public static final String PROTO_CONTENT_TYPE = "application/cloudevents+protobuf";
    public static final String PROTO_DATA_CONTENT_TYPE = "application/protobuf";

    @Override
    public byte[] serialize(CloudEvent event) throws EventSerializationException {
        try {
            io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent asProto = ProtoSerializer.toProto(event);
            return asProto.toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            throw new EventSerializationException(e);
        }
    }

    @Override
    public CloudEvent deserialize(byte[] bytes, CloudEventDataMapper<? extends CloudEventData> mapper) throws EventDeserializationException {
        try {
            io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent ceProto = io.confluent.shaded.io.cloudevents.v1.proto.CloudEvent.parseFrom(bytes);
            return (CloudEvent)new ProtoDeserializer(ceProto).read(CloudEventBuilder::fromSpecVersion);
        }
        catch (InvalidProtocolBufferException e) {
            throw new EventDeserializationException(e);
        }
    }

    @Override
    public String serializedContentType() {
        return PROTO_CONTENT_TYPE;
    }
}

