/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.rw;

import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.io.cloudevents.types.Time;
import io.confluent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Base64;

@ParametersAreNonnullByDefault
public interface CloudEventContextWriter {
    public CloudEventContextWriter withContextAttribute(String var1, String var2) throws CloudEventRWException;

    default public CloudEventContextWriter withContextAttribute(String name, URI value) throws CloudEventRWException {
        return this.withContextAttribute(name, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
        return this.withContextAttribute(name, Time.writeTime(name, value));
    }

    default public CloudEventContextWriter withContextAttribute(String name, Number value) throws CloudEventRWException {
        return this.withContextAttribute(name, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name, Integer value) throws CloudEventRWException {
        return this.withContextAttribute(name, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name, Boolean value) throws CloudEventRWException {
        return this.withContextAttribute(name, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name, byte[] value) throws CloudEventRWException {
        return this.withContextAttribute(name, Base64.getEncoder().encodeToString(value));
    }
}

