/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.serializers;

import io.confluent.shaded.com.google.common.io.BaseEncoding;
import io.confluent.shaded.com.google.gson.Gson;
import io.confluent.shaded.io.confluent.serializers.UberSerde;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class UberSerdes {
    public static final BaseEncoding BASE_64 = BaseEncoding.base64();

    public static UberSerde<Long> longs() {
        return new DelegatingUberSerde<Long>(Serdes.Long()){

            @Override
            public Class<Long> type() {
                return Long.class;
            }

            @Override
            public String toJson(Long message) {
                return new Gson().toJson(message);
            }

            @Override
            public byte[] fromJson(String json) {
                return this.serialize(new Gson().fromJson(json, Long.class));
            }
        };
    }

    public static <T> UberSerde<T> fromSerde(Serde<T> serde, final Class<T> clazz) {
        return new DelegatingUberSerde<T>(serde){

            @Override
            public Class<T> type() {
                return clazz;
            }

            @Override
            public byte[] fromJson(String json) {
                return BASE_64.decode(new Gson().fromJson(json, String.class));
            }

            @Override
            public String toJson(T message) {
                return new Gson().toJson(BASE_64.encode(this.serialize(message)));
            }
        };
    }

    public static abstract class DelegatingUberSerde<T>
    implements UberSerde<T> {
        private final Serde<T> serde;

        public DelegatingUberSerde(Serde<T> serde) {
            this.serde = serde;
        }

        @Override
        public byte[] serialize(T message) {
            return this.serde.serializer().serialize(null, message);
        }

        public byte[] serialize(String topic, T data) {
            return this.serde.serializer().serialize(topic, data);
        }

        @Override
        public T deserialize(byte[] bytes) {
            return (T)this.serde.deserializer().deserialize(null, bytes);
        }

        public T deserialize(String topic, byte[] data) {
            return (T)this.serde.deserializer().deserialize(topic, data);
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
            this.serde.configure(configs, isKey);
        }

        @Override
        public void close() {
            this.serde.close();
        }

        public Serializer<T> serializer() {
            return this.serde.serializer();
        }

        public Deserializer<T> deserializer() {
            return this.serde.deserializer();
        }
    }
}

