/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.io.confluent.telemetry.ResourceLabelProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;

public class HostResourceLabelProvider
implements ResourceLabelProvider {
    public static final String NAMESPACE = "host";
    public static final String KEY_HOSTNAME = "host.hostname";
    private final Map<String, String> environment;

    public HostResourceLabelProvider() {
        this(System.getenv());
    }

    @VisibleForTesting
    HostResourceLabelProvider(Map<String, String> environment) {
        this.environment = environment;
    }

    @Override
    public Map<String, String> getLabels() {
        String hostname = this.environment.get("HOSTNAME");
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (hostname != null) {
            return Collections.singletonMap(KEY_HOSTNAME, hostname);
        }
        return Collections.emptyMap();
    }
}

