/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.client;

import io.confluent.shaded.io.netty.util.HashedWheelTimer;
import io.confluent.shaded.io.netty.util.Timer;
import io.confluent.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.confluent.shaded.org.asynchttpclient.config.AsyncHttpClientConfigDefaults;
import java.util.concurrent.TimeUnit;

public final class AsyncHttpClientTimer {
    public static final String TIMER_THREAD_SUFFIX = "-timer";
    private final Timer timer;

    private AsyncHttpClientTimer() {
        boolean isDaemon = true;
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(AsyncHttpClientConfigDefaults.defaultThreadPoolName() + TIMER_THREAD_SUFFIX, isDaemon);
        long tickDuration = AsyncHttpClientConfigDefaults.defaultHashedWheelTimerTickDuration();
        int hashedWheelSize = AsyncHttpClientConfigDefaults.defaultHashedWheelTimerSize();
        HashedWheelTimer hashedWheelTimer = new HashedWheelTimer(threadFactory, tickDuration, TimeUnit.MILLISECONDS, hashedWheelSize);
        hashedWheelTimer.start();
        this.timer = hashedWheelTimer;
    }

    public static Timer getInstance() {
        return AsyncHttpClientTimerHolder.INSTANCE.timer;
    }

    private static class AsyncHttpClientTimerHolder {
        private static final AsyncHttpClientTimer INSTANCE = new AsyncHttpClientTimer();

        private AsyncHttpClientTimerHolder() {
        }
    }
}

