/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.client;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.io.confluent.telemetry.client.AsyncHttpClientTimer;
import io.confluent.shaded.io.confluent.telemetry.client.CloseableRxHttpClient;
import io.confluent.shaded.io.confluent.telemetry.client.CompressionAlgorithm;
import io.confluent.shaded.io.confluent.telemetry.client.Compressor;
import io.confluent.shaded.io.confluent.telemetry.client.Credentials;
import io.confluent.shaded.io.confluent.telemetry.client.ProxyConfig;
import io.confluent.shaded.io.confluent.telemetry.client.RequestSerializer;
import io.confluent.shaded.io.confluent.telemetry.client.ResponseDeserializer;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryClientException;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryHttpResponse;
import io.confluent.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.confluent.shaded.io.netty.handler.codec.http.HttpStatusClass;
import io.confluent.shaded.io.netty.handler.ssl.SslContext;
import io.confluent.shaded.io.netty.util.Timer;
import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.Single;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.subjects.SingleSubject;
import io.confluent.shaded.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import io.confluent.shaded.org.asynchttpclient.Dsl;
import io.confluent.shaded.org.asynchttpclient.Request;
import io.confluent.shaded.org.asynchttpclient.RequestBuilder;
import io.confluent.shaded.org.asynchttpclient.Response;
import io.confluent.shaded.org.asynchttpclient.extras.guava.RateLimitedThrottleRequestFilter;
import io.confluent.shaded.org.asynchttpclient.proxy.ProxyServer;
import io.confluent.shaded.org.asynchttpclient.util.HttpConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryHttpClient<T, S>
implements AutoCloseable {
    public static final String V1_METRICS_ENDPOINT = "/v1/metrics";
    private static final Logger logger = LoggerFactory.getLogger(TelemetryHttpClient.class);
    private static final String CONTENT_TYPE_X_PROTOBUF = "application/x-protobuf";
    private final String contentType;
    private final String acceptType;
    private final CloseableRxHttpClient httpClient;
    private final Supplier<Credentials> credentialsSupplier;
    private final Supplier<ProxyConfig> proxyConfigSupplier;
    private final String requestUrl;
    private final int maxAttempts;
    private final int retryDelay;
    private final Compressor compressor;
    private final RequestSerializer<T> requestSerializer;
    private final ResponseDeserializer<S> responseDeserializer;
    @VisibleForTesting
    static final String EXCEPTION_MSG_FORMAT_STRING = "Failed to send request %s %s after %d attempt(s). Last error: %s";

    private TelemetryHttpClient(Builder<T, S> builder) {
        this.requestUrl = ((Builder)builder).baseUrl + ((Builder)builder).endpoint;
        this.credentialsSupplier = ((Builder)builder).credentialsSupplier;
        this.contentType = ((Builder)builder).contentType;
        this.acceptType = ((Builder)builder).acceptType;
        this.maxAttempts = ((Builder)builder).maxAttempts;
        this.retryDelay = ((Builder)builder).retryDelay;
        this.compressor = ((Builder)builder).compression.createCompressor();
        this.requestSerializer = ((Builder)builder).requestSerializer;
        this.responseDeserializer = ((Builder)builder).responseDeserializer;
        this.proxyConfigSupplier = ((Builder)builder).proxyConfigSupplier;
        if (((Builder)builder).httpClient != null) {
            this.httpClient = ((Builder)builder).httpClient;
            return;
        }
        Timer timer = ((Builder)builder).timer != null ? ((Builder)builder).timer : AsyncHttpClientTimer.getInstance();
        DefaultAsyncHttpClientConfig.Builder config = Dsl.config().setNettyTimer(timer).setRequestTimeout(((Builder)builder).requestTimeout).setConnectTimeout(((Builder)builder).connectTimeout).setMaxRequestRetry(0);
        if (((Builder)builder).maxConnections > 0) {
            config.setMaxConnections(((Builder)builder).maxConnections);
        }
        if (((Builder)builder).sslContext != null) {
            config.setSslContext(((Builder)builder).sslContext);
        }
        if (((Builder)builder).rateLimitPerSecond > 0.0) {
            if (((Builder)builder).maxConnections < 0) {
                throw new TelemetryClientException("Failed to create RateLimitedThrottleRequestFilter. MaxConnections needs to be set to non-negative value before adding the RateLimitedThrottleRequestFilter.");
            }
            config.addRequestFilter(new RateLimitedThrottleRequestFilter(((Builder)builder).maxConnections, ((Builder)builder).rateLimitPerSecond));
        }
        this.httpClient = new CloseableRxHttpClient(Dsl.asyncHttpClient(config));
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private byte[] serializeAndCompress(T message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream encodingOutputStream = this.compressor.compress(baos);){
            this.requestSerializer.serialize(encodingOutputStream, message);
        }
        return baos.toByteArray();
    }

    public Single<TelemetryHttpResponse<S>> submit(T payload) {
        byte[] messageBytes;
        SingleSubject<TelemetryHttpResponse<S>> subject = SingleSubject.create();
        try {
            messageBytes = this.serializeAndCompress(payload);
        }
        catch (IOException e) {
            subject.onError(new TelemetryClientException("Failed to serialize protobuf message", e));
            return subject;
        }
        RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(HttpConstants.Methods.POST).setUrl(this.requestUrl)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, this.contentType)).setHeader((CharSequence)HttpHeaderNames.ACCEPT, this.acceptType)).setBody(messageBytes);
        requestBuilder = this.setContentEncoding(requestBuilder);
        requestBuilder = this.setDynamicCredentials(requestBuilder);
        Request request = requestBuilder.build();
        Disposable disposable = this.httpClient.prepare(request).doOnSubscribe(it -> logger.debug("Submitting payload to {}", (Object)this.requestUrl)).map(response -> {
            if (HttpStatusClass.valueOf(response.getStatusCode()) != HttpStatusClass.SUCCESS) {
                throw new TelemetryClientException(String.format("%d %s: %s", response.getStatusCode(), response.getStatusText(), response.toString()));
            }
            return new TelemetryHttpResponse<S>((Response)response, this.responseDeserializer.deserialize(response.getResponseBodyAsByteBuffer()));
        }).retryWhen(exceptions -> exceptions.zipWith(Flowable.range(1, this.maxAttempts), (ex, attempt) -> {
            if (attempt >= this.maxAttempts) {
                throw new TelemetryClientException(String.format(EXCEPTION_MSG_FORMAT_STRING, request.getMethod(), this.requestUrl, this.maxAttempts, ex), (Throwable)ex);
            }
            logger.debug("Error sending request {} {} (attempt {} of {}, will retry in {} second(s)...): {}", new Object[]{request.getMethod(), this.requestUrl, attempt, this.maxAttempts, this.retryDelay, ex});
            return ex;
        }).delay(this.retryDelay, TimeUnit.SECONDS)).subscribe(response -> {
            logger.debug("Successfully sent request to {}", (Object)this.requestUrl);
            subject.onSuccess((TelemetryHttpResponse<S>)response);
        }, exception -> {
            logger.error("Failed to send request {} {} after {} attempts.", new Object[]{request.getMethod(), this.requestUrl, this.maxAttempts, exception});
            String msg = String.format("Failed to send request %s %s: %s", request.getMethod(), this.requestUrl, exception);
            subject.onError(exception instanceof TelemetryClientException ? exception : new TelemetryClientException(msg, (Throwable)exception));
        });
        return subject.doOnDispose(() -> disposable.dispose());
    }

    @VisibleForTesting
    RequestBuilder setContentEncoding(RequestBuilder requestBuilder) {
        if (this.compressor.getHttpHeaderValue() != null) {
            requestBuilder.setHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING, this.compressor.getHttpHeaderValue());
        }
        return requestBuilder;
    }

    @VisibleForTesting
    RequestBuilder setDynamicCredentials(RequestBuilder requestBuilder) {
        ProxyConfig proxyConfig;
        Credentials credentials = this.credentialsSupplier.get();
        if (credentials != null) {
            requestBuilder.setRealm(Dsl.basicAuthRealm(credentials.getUsername(), credentials.getPassword()).setUsePreemptiveAuth(true));
        }
        if ((proxyConfig = this.proxyConfigSupplier.get()) != null) {
            URI proxyUrl = proxyConfig.getProxyUrl();
            ProxyServer.Builder proxyServer = Dsl.proxyServer(proxyUrl.getHost(), proxyUrl.getPort());
            Credentials proxyCredentials = proxyConfig.getProxyCredentials();
            if (proxyCredentials != null) {
                proxyServer.setRealm(Dsl.basicAuthRealm(proxyCredentials.getUsername(), proxyCredentials.getPassword()).setUsePreemptiveAuth(true));
            }
            requestBuilder.setProxyServer(proxyServer);
        }
        return requestBuilder;
    }

    public static class Builder<T, S> {
        private static final URI DEFAULT_BASE_URL = URI.create("https://collector.telemetry.confluent.cloud");
        private static final int DEFAULT_REQUEST_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        private static final int DEFAULT_CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
        private static final int DEFAULT_MAX_ATTEMPTS = 3;
        private static final int DEFAULT_MAX_CONNECTIONS = -1;
        private static final int DEFAULT_RETRY_DELAY = 5;
        private static final double DEFAULT_RATE_LIMIT_PER_SECOND = -1.0;
        private static final CompressionAlgorithm DEFAULT_COMPRESSION = CompressionAlgorithm.ZSTD;
        private static final String DEFAULT_CONTENT_TYPE = "application/x-protobuf";
        private URI baseUrl = DEFAULT_BASE_URL;
        private String endpoint = "/v1/metrics";
        private String contentType = "application/x-protobuf";
        private String acceptType = "application/x-protobuf";
        private Supplier<Credentials> credentialsSupplier = () -> null;
        private Supplier<ProxyConfig> proxyConfigSupplier = () -> null;
        private RequestSerializer<T> requestSerializer;
        private ResponseDeserializer<S> responseDeserializer;
        private CloseableRxHttpClient httpClient;
        private SslContext sslContext;
        private Timer timer;
        private int requestTimeout = DEFAULT_REQUEST_TIMEOUT;
        private int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        private int maxAttempts = 3;
        private int maxConnections = -1;
        private int retryDelay = 5;
        private double rateLimitPerSecond = -1.0;
        private CompressionAlgorithm compression = DEFAULT_COMPRESSION;

        @VisibleForTesting
        Builder<T, S> setHttpClient(CloseableRxHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder<T, S> setRequestSerializer(RequestSerializer<T> requestSerializer) {
            Preconditions.checkNotNull(requestSerializer, "serializer must not be null");
            this.requestSerializer = requestSerializer;
            return this;
        }

        public Builder<T, S> setResponseDeserializer(ResponseDeserializer<S> responseDeserializer) {
            Preconditions.checkNotNull(responseDeserializer, "deserializer must not be null");
            this.responseDeserializer = responseDeserializer;
            return this;
        }

        public Builder<T, S> setBaseUrl(URI baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl must not be null");
            return this;
        }

        public Builder<T, S> setCredentialsSupplier(Supplier<Credentials> credentialsSupplier) {
            this.credentialsSupplier = Objects.requireNonNull(credentialsSupplier, "credentialsSupplier must not be null");
            return this;
        }

        public Builder<T, S> setProxyConfigSupplier(Supplier<ProxyConfig> proxyConfigSupplier) {
            this.proxyConfigSupplier = Objects.requireNonNull(proxyConfigSupplier, "proxyConfigSupplier must not be null");
            return this;
        }

        public Builder<T, S> setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder<T, S> setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder<T, S> setRateLimitPerSecond(double rateLimitPerSecond) {
            this.rateLimitPerSecond = rateLimitPerSecond;
            return this;
        }

        public Builder<T, S> setRetryDelay(int retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder<T, S> setTimer(Timer timer) {
            this.timer = timer;
            return this;
        }

        public Builder<T, S> setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder<T, S> setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder<T, S> setCompression(CompressionAlgorithm compression) {
            this.compression = compression;
            return this;
        }

        public Builder<T, S> setSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder<T, S> setEndpoint(String endpoint) {
            Preconditions.checkNotNull(endpoint);
            this.endpoint = endpoint;
            return this;
        }

        public Builder<T, S> setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder<T, S> setAcceptType(String acceptType) {
            this.acceptType = acceptType;
            return this;
        }

        public TelemetryHttpClient<T, S> build() {
            Preconditions.checkState(this.responseDeserializer != null, "Must specify a deserializer when building %s", TelemetryHttpClient.class);
            Preconditions.checkState(this.requestSerializer != null, "Must specify a serializer when building %s", TelemetryHttpClient.class);
            return new TelemetryHttpClient(this);
        }
    }
}

