/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.com.google.common.collect.ImmutableSet;
import io.confluent.shaded.com.google.common.collect.Sets;
import io.confluent.shaded.io.confluent.telemetry.config.NamedFilter;
import io.confluent.telemetry.PredicateUtils;
import io.confluent.telemetry.metrics.Keyed;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FilterSetPredicate
implements Predicate<Keyed> {
    private Set<NamedFilterPredicate> filters;

    public FilterSetPredicate(NamedFilter filter) {
        Preconditions.checkNotNull(filter, "Filter can't be null");
        this.filters = ImmutableSet.of(new NamedFilterPredicate(filter));
    }

    public FilterSetPredicate(Set<NamedFilter> filters) {
        Preconditions.checkNotNull(filters, "Filters can't be null");
        this.filters = filters.stream().map(NamedFilterPredicate::new).collect(Collectors.toSet());
    }

    private FilterSetPredicate() {
    }

    private FilterSetPredicate setFilters(Set<NamedFilterPredicate> filters) {
        this.filters = filters;
        return this;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    @VisibleForTesting
    Set<NamedFilterPredicate> getFilters() {
        return this.filters;
    }

    public FilterSetPredicate subset(Set<String> filterNames) {
        Set<NamedFilterPredicate> selectedFilters = this.filters.stream().filter(f -> filterNames.contains(f.getName())).collect(Collectors.toSet());
        if (selectedFilters.size() != filterNames.size()) {
            Set existingFilters = this.filters.stream().map(NamedFilter::getName).collect(Collectors.toSet());
            String missing = filterNames.stream().filter(f -> !existingFilters.contains(f)).findFirst().get();
            throw new NoSuchElementException(String.format("Filter '%s' does not exist.", missing));
        }
        return new FilterSetPredicate().setFilters(selectedFilters);
    }

    public FilterSetPredicate union(FilterSetPredicate other) {
        Set currentFiltersNames = this.filters.stream().map(NamedFilter::getName).collect(Collectors.toSet());
        Set newAdditions = other.filters.stream().filter(f -> !currentFiltersNames.contains(f.getName())).collect(Collectors.toSet());
        return new FilterSetPredicate().setFilters(Sets.union(this.filters, newAdditions));
    }

    @Override
    public boolean test(Keyed key) {
        for (NamedFilterPredicate filter : this.filters) {
            if (!filter.test(key)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterSetPredicate that = (FilterSetPredicate)o;
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    @VisibleForTesting
    static class NamedFilterPredicate
    extends NamedFilter
    implements Predicate<Keyed> {
        private final Predicate<Keyed> predicate;

        public NamedFilterPredicate(NamedFilter filter) {
            super(filter.getName(), filter.getInclude());
            this.predicate = PredicateUtils.buildCachingMetricsPredicate(filter.getInclude());
        }

        @VisibleForTesting
        Predicate<Keyed> getPredicate() {
            return this.predicate;
        }

        @Override
        public boolean test(Keyed key) {
            return this.predicate.test(key);
        }
    }
}

