/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config.remote.polling;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigurationSource;
import io.confluent.shaded.io.confluent.telemetry.config.remote.v1.RemoteConfiguration;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollingRemoteConfigurationSource
implements RemoteConfigurationSource {
    private static final Logger log = LoggerFactory.getLogger(PollingRemoteConfigurationSource.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("confluent-telemetry-reporter-remote-config-poller-%d").setDaemon(true).setUncaughtExceptionHandler((t2, e) -> log.error("Uncaught exception in thread '{}':", (Object)t2.getName(), (Object)e)).build());
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final long refreshIntervalMs;
    private volatile Consumer<RemoteConfiguration> callback;
    @VisibleForTesting
    RemoteConfiguration currentConfig;

    public PollingRemoteConfigurationSource(long refreshIntervalMs, Consumer<RemoteConfiguration> callback) {
        Preconditions.checkArgument(refreshIntervalMs > 0L, "refresh interval must be greater than 0");
        this.refreshIntervalMs = refreshIntervalMs;
        this.callback = callback;
    }

    @Override
    public RemoteConfiguration getConfig() {
        return this.currentConfig != null ? this.currentConfig : null;
    }

    @Override
    public void setConfigurationChangeCallback(Consumer<RemoteConfiguration> callback) {
        this.callback = callback;
    }

    @Override
    public void stop() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
        this.callback = null;
    }

    @Override
    public void start() {
        if (this.executor.isShutdown() || !this.isStarted.compareAndSet(false, true)) {
            throw new IllegalStateException("RemoteConfigurationSource can't be started");
        }
        this.executor.scheduleWithFixedDelay(this::refresh, 0L, this.refreshIntervalMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    void refresh() {
        try {
            if (this.callback != null) {
                this.requestConfig().ifPresent(response -> {
                    if (!response.getFilters().isEmpty() || Objects.equals(response.getActiveFilters(), ConfluentTelemetryConfig.DEFAULT_ACTIVE_FILTER_SET)) {
                        this.callback.accept((RemoteConfiguration)response);
                        this.currentConfig = response;
                    } else {
                        log.warn("No filters defined in remote config. Skipping exporter reconfiguration");
                    }
                });
            }
        }
        catch (Throwable ex) {
            if (ex.getCause() instanceof InterruptedException) {
                return;
            }
            log.error("Unable to retrieve RemoteConfiguration from Source '{}':", this.getClass(), (Object)ex);
        }
    }

    protected abstract Optional<RemoteConfiguration> requestConfig();
}

