/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes;

import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.confluent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.shaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.io.confluent.telemetry.config.remote.v1.RemoteConfiguration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSet {
    private static final Logger log = LoggerFactory.getLogger(ConfigSet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final Set<ConfigSetEntry> configs;

    public ConfigSet(Set<ConfigSetEntry> configs) {
        this.configs = configs;
    }

    public static ConfigSet parseConfigYaml(String configs) throws JsonProcessingException {
        return new ConfigSet(MAPPER.readValue(configs, new TypeReference<Set<ConfigSetEntry>>(){}));
    }

    public Optional<RemoteConfiguration> getCompatibleConfigVersion(String schemaVersion) {
        for (ConfigSetEntry entry : this.configs) {
            if (!ConfigSet.isVersionCompatible(schemaVersion, entry.getVersion())) continue;
            log.debug("Using config version: " + entry.getVersion());
            return Optional.of(entry.getConfig());
        }
        log.info("No compatible config versions found");
        return Optional.empty();
    }

    private static boolean isVersionCompatible(String version, String versionToCompare) {
        int versionMajor = Integer.parseInt(version.split("[.]")[0]);
        int versionToCompareMajor = Integer.parseInt(versionToCompare.split("[.]")[0]);
        int versionMinor = Integer.parseInt(version.split("[.]")[1]);
        int versionToCompareMinor = Integer.parseInt(versionToCompare.split("[.]")[1]);
        return versionMajor == versionToCompareMajor && versionMinor <= versionToCompareMinor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSet configSet = (ConfigSet)o;
        return Objects.equals(this.configs, configSet.configs);
    }

    public int hashCode() {
        return Objects.hash(this.configs);
    }

    @VisibleForTesting
    static class ConfigSetEntry {
        private final String version;
        private final RemoteConfiguration config;

        @JsonCreator
        public ConfigSetEntry(@JsonProperty(value="version") String version, @JsonProperty(value="value") RemoteConfiguration config) {
            this.version = version;
            this.config = config;
        }

        public String getVersion() {
            return this.version;
        }

        public RemoteConfiguration getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigSetEntry that = (ConfigSetEntry)o;
            return Objects.equals(this.version, that.version) && Objects.equals(this.config, that.config);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.config);
        }
    }
}

