/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.events;

import io.confluent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.shaded.com.google.protobuf.Message;
import io.confluent.shaded.com.google.protobuf.util.JsonFormat;
import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.core.data.BytesCloudEventData;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.provider.EventFormatProvider;
import io.confluent.shaded.io.cloudevents.core.v1.CloudEventBuilder;
import io.confluent.telemetry.api.events.Event;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.UUID;

public class EventUtils {
    private static EventFormat jsonFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    public static CloudEvent toCloudEvent(Event e) {
        Objects.requireNonNull(e.source());
        Objects.requireNonNull(e.subject());
        Objects.requireNonNull(e.type());
        CloudEventBuilder builder = io.confluent.shaded.io.cloudevents.core.builder.CloudEventBuilder.v1().withType(e.type()).withSource(e.source()).withSubject(e.subject());
        if (e.id() == null) {
            builder.withId(UUID.randomUUID().toString());
        } else {
            builder.withId(e.id());
        }
        if (e.time() == null) {
            builder.withTime(OffsetDateTime.now(ZoneOffset.UTC));
        } else {
            builder.withTime(e.time());
        }
        if (e.data().isPresent()) {
            Objects.requireNonNull(e.dataContentType());
            builder.withData(e.dataContentType(), BytesCloudEventData.wrap(e.data().get()));
        }
        if (e.dataSchema().isPresent()) {
            builder.withDataSchema(e.dataSchema().get());
        }
        for (String ext : e.extensionNames()) {
            builder.withExtension(ext, e.extension(ext));
        }
        return builder.build();
    }

    public static String toJson(Event event) {
        return EventUtils.toJson(EventUtils.toCloudEvent(event));
    }

    public static String toJson(CloudEvent event) {
        return new String(jsonFormat.serialize(event), StandardCharsets.UTF_8);
    }

    public static byte[] protoToBytes(Message data, String dataContentType) {
        switch (dataContentType) {
            case "application/json": {
                try {
                    return JsonFormat.printer().omittingInsignificantWhitespace().includingDefaultValueFields().print(data).getBytes();
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }
            case "application/protobuf": 
            case "application/x-protobuf": {
                return data.toByteArray();
            }
        }
        throw new RuntimeException("unknown datacontenttype " + dataContentType);
    }
}

