/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka;

import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.message.Encoding;
import io.confluent.shaded.io.cloudevents.core.provider.EventFormatProvider;
import io.confluent.shaded.io.cloudevents.kafka.impl.KafkaSerializerMessageWriterImpl;
import io.confluent.shaded.io.confluent.telemetry.events.EventUtils;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka.KafkaExporterConfig;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka.async.AsyncKafkaExporter;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka.async.SingleTopicSupplier;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka.async.TopicSupplier;
import io.confluent.telemetry.api.events.Event;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAsyncKafkaExporter
extends AsyncKafkaExporter<Event> {
    private static final Logger log = LoggerFactory.getLogger(EventAsyncKafkaExporter.class);
    public static EventFormat format = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    protected EventAsyncKafkaExporter(Builder builder) {
        super(builder.producerProperties, builder.bufferSize, builder.topicSupplier, builder.dataSerializer);
    }

    public static Builder newBuilder(Map<String, Object> config) {
        Encoding encoding = config.containsKey("cloudevent.codec") && config.get("cloudevent.codec").equals(Encoding.STRUCTURED.toString()) ? Encoding.STRUCTURED : Encoding.BINARY;
        KafkaExporterConfig kafkaExporterConfig = new KafkaExporterConfig(config);
        SingleTopicSupplier<Event> topicSupplier = new SingleTopicSupplier<Event>(new NewTopic(kafkaExporterConfig.getTopicName(), kafkaExporterConfig.getTopicPartitions(), (short)kafkaExporterConfig.getTopicReplicas()).configs(kafkaExporterConfig.getTopicConfig()), kafkaExporterConfig.getProducerProperties());
        Function<Event, ProducerRecord<String, byte[]>> dataSerializer = event -> {
            String topic = kafkaExporterConfig.getTopicName();
            String key = null;
            if (event.extensionNames().contains("route")) {
                topic = event.extension("route");
            }
            if (event.extensionNames().contains("partitionkey")) {
                key = event.extension("partitionkey");
            }
            CloudEvent data = EventUtils.toCloudEvent(event);
            RecordHeaders headers = new RecordHeaders();
            byte[] binaryData = encoding == Encoding.STRUCTURED ? (byte[])new KafkaSerializerMessageWriterImpl((Headers)headers).writeStructured(data, format) : (byte[])new KafkaSerializerMessageWriterImpl((Headers)headers).writeBinary(data);
            return new ProducerRecord(topic, null, null, (Object)key, (Object)binaryData, (Iterable)headers);
        };
        return new Builder().withProducerProperties(kafkaExporterConfig.getProducerProperties()).withBufferSize(kafkaExporterConfig.getInt("event.queue.size")).withTopicSupplier(topicSupplier).withDataSerializer(dataSerializer);
    }

    public static final class Builder {
        private Properties producerProperties;
        private int bufferSize = 500;
        private TopicSupplier<Event> topicSupplier;
        private Function<Event, ProducerRecord<String, byte[]>> dataSerializer;

        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder withProducerProperties(Properties producerProperties) {
            this.producerProperties = producerProperties;
            return this;
        }

        public Builder withTopicSupplier(TopicSupplier<Event> topicSupplier) {
            this.topicSupplier = topicSupplier;
            return this;
        }

        public Builder withDataSerializer(Function<Event, ProducerRecord<String, byte[]>> dataSerializer) {
            this.dataSerializer = dataSerializer;
            return this;
        }

        public EventAsyncKafkaExporter build() {
            Objects.requireNonNull(this.producerProperties);
            return new EventAsyncKafkaExporter(this);
        }
    }
}

