/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.exceptions;

import io.confluent.shaded.io.reactivex.annotations.NonNull;
import io.confluent.shaded.io.reactivex.internal.util.ExceptionHelper;

public final class Exceptions {
    private Exceptions() {
        throw new IllegalStateException("No instances!");
    }

    @NonNull
    public static RuntimeException propagate(@NonNull Throwable t2) {
        throw ExceptionHelper.wrapOrThrow(t2);
    }

    public static void throwIfFatal(@NonNull Throwable t2) {
        if (t2 instanceof VirtualMachineError) {
            throw (VirtualMachineError)t2;
        }
        if (t2 instanceof ThreadDeath) {
            throw (ThreadDeath)t2;
        }
        if (t2 instanceof LinkageError) {
            throw (LinkageError)t2;
        }
    }
}

