/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.observers;

import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.QueueDisposable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;

public abstract class BasicFuseableObserver<T, R>
implements Observer<T>,
QueueDisposable<R> {
    protected final Observer<? super R> downstream;
    protected Disposable upstream;
    protected QueueDisposable<T> qd;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableObserver(Observer<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public final void onSubscribe(Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            if (d instanceof QueueDisposable) {
                this.qd = (QueueDisposable)d;
            }
            if (this.beforeDownstream()) {
                this.downstream.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.downstream.onError(t2);
    }

    protected final void fail(Throwable t2) {
        Exceptions.throwIfFatal(t2);
        this.upstream.dispose();
        this.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.downstream.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueDisposable<T> qd = this.qd;
        if (qd != null && (mode & 4) == 0) {
            int m4 = qd.requestFusion(mode);
            if (m4 != 0) {
                this.sourceMode = m4;
            }
            return m4;
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public boolean isEmpty() {
        return this.qd.isEmpty();
    }

    @Override
    public void clear() {
        this.qd.clear();
    }

    @Override
    public final boolean offer(R e) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v1, R v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

