/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.observers;

import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.annotations.Nullable;
import io.confluent.shaded.io.reactivex.internal.observers.BasicIntQueueDisposable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;

public class DeferredScalarDisposable<T>
extends BasicIntQueueDisposable<T> {
    private static final long serialVersionUID = -5502432239815349361L;
    protected final Observer<? super T> downstream;
    protected T value;
    static final int TERMINATED = 2;
    static final int DISPOSED = 4;
    static final int FUSED_EMPTY = 8;
    static final int FUSED_READY = 16;
    static final int FUSED_CONSUMED = 32;

    public DeferredScalarDisposable(Observer<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public final int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.lazySet(8);
            return 2;
        }
        return 0;
    }

    public final void complete(T value) {
        int state = this.get();
        if ((state & 0x36) != 0) {
            return;
        }
        Observer<T> a = this.downstream;
        if (state == 8) {
            this.value = value;
            this.lazySet(16);
            a.onNext(null);
        } else {
            this.lazySet(2);
            a.onNext(value);
        }
        if (this.get() != 4) {
            a.onComplete();
        }
    }

    public final void error(Throwable t2) {
        int state = this.get();
        if ((state & 0x36) != 0) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.lazySet(2);
        this.downstream.onError(t2);
    }

    public final void complete() {
        int state = this.get();
        if ((state & 0x36) != 0) {
            return;
        }
        this.lazySet(2);
        this.downstream.onComplete();
    }

    @Override
    @Nullable
    public final T poll() throws Exception {
        if (this.get() == 16) {
            T v = this.value;
            this.value = null;
            this.lazySet(32);
            return v;
        }
        return null;
    }

    @Override
    public final boolean isEmpty() {
        return this.get() != 16;
    }

    @Override
    public final void clear() {
        this.lazySet(32);
        this.value = null;
    }

    @Override
    public void dispose() {
        this.set(4);
        this.value = null;
    }

    public final boolean tryDispose() {
        return this.getAndSet(4) != 4;
    }

    @Override
    public final boolean isDisposed() {
        return this.get() == 4;
    }
}

