/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.observers;

import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Action;
import io.confluent.shaded.io.reactivex.functions.Consumer;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;

public final class DisposableLambdaObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> downstream;
    final Consumer<? super Disposable> onSubscribe;
    final Action onDispose;
    Disposable upstream;

    public DisposableLambdaObserver(Observer<? super T> actual, Consumer<? super Disposable> onSubscribe, Action onDispose) {
        this.downstream = actual;
        this.onSubscribe = onSubscribe;
        this.onDispose = onDispose;
    }

    @Override
    public void onSubscribe(Disposable d) {
        try {
            this.onSubscribe.accept(d);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            d.dispose();
            this.upstream = DisposableHelper.DISPOSED;
            EmptyDisposable.error(e, this.downstream);
            return;
        }
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        this.downstream.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.upstream != DisposableHelper.DISPOSED) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(t2);
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.upstream != DisposableHelper.DISPOSED) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onComplete();
        }
    }

    @Override
    public void dispose() {
        Disposable d = this.upstream;
        if (d != DisposableHelper.DISPOSED) {
            this.upstream = DisposableHelper.DISPOSED;
            try {
                this.onDispose.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
            d.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }
}

