/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableAmb<T>
extends Flowable<T> {
    final Publisher<? extends T>[] sources;
    final Iterable<? extends Publisher<? extends T>> sourcesIterable;

    public FlowableAmb(Publisher<? extends T>[] sources, Iterable<? extends Publisher<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Publisher<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Publisher[8];
            try {
                for (Publisher<? extends T> publisher : this.sourcesIterable) {
                    if (publisher == null) {
                        EmptySubscription.error(new NullPointerException("One of the sources is null"), s2);
                        return;
                    }
                    if (count == sources.length) {
                        Publisher[] b = new Publisher[count + (count >> 2)];
                        System.arraycopy(sources, 0, b, 0, count);
                        sources = b;
                    }
                    sources[count++] = publisher;
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptySubscription.error(e, s2);
                return;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s2);
            return;
        }
        if (count == 1) {
            sources[0].subscribe(s2);
            return;
        }
        AmbCoordinator<? extends T> ac = new AmbCoordinator<T>(s2, count);
        ac.subscribe(sources);
    }

    static final class AmbInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -1185974347409665484L;
        final AmbCoordinator<T> parent;
        final int index;
        final Subscriber<? super T> downstream;
        boolean won;
        final AtomicLong missedRequested = new AtomicLong();

        AmbInnerSubscriber(AmbCoordinator<T> parent, int index, Subscriber<? super T> downstream) {
            this.parent = parent;
            this.index = index;
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.deferredSetOnce(this, this.missedRequested, s2);
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this, this.missedRequested, n);
        }

        @Override
        public void onNext(T t2) {
            if (this.won) {
                this.downstream.onNext(t2);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onNext(t2);
            } else {
                ((Subscription)this.get()).cancel();
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.won) {
                this.downstream.onError(t2);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onError(t2);
            } else {
                ((Subscription)this.get()).cancel();
                RxJavaPlugins.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.won) {
                this.downstream.onComplete();
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onComplete();
            } else {
                ((Subscription)this.get()).cancel();
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class AmbCoordinator<T>
    implements Subscription {
        final Subscriber<? super T> downstream;
        final AmbInnerSubscriber<T>[] subscribers;
        final AtomicInteger winner = new AtomicInteger();

        AmbCoordinator(Subscriber<? super T> actual, int count) {
            this.downstream = actual;
            this.subscribers = new AmbInnerSubscriber[count];
        }

        public void subscribe(Publisher<? extends T>[] sources) {
            int i;
            AmbInnerSubscriber<T>[] as = this.subscribers;
            int len = as.length;
            for (i = 0; i < len; ++i) {
                as[i] = new AmbInnerSubscriber<T>(this, i + 1, this.downstream);
            }
            this.winner.lazySet(0);
            this.downstream.onSubscribe(this);
            for (i = 0; i < len; ++i) {
                if (this.winner.get() != 0) {
                    return;
                }
                sources[i].subscribe(as[i]);
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                int w = this.winner.get();
                if (w > 0) {
                    this.subscribers[w - 1].request(n);
                } else if (w == 0) {
                    for (AmbInnerSubscriber<T> a : this.subscribers) {
                        a.request(n);
                    }
                }
            }
        }

        public boolean win(int index) {
            int w = this.winner.get();
            if (w == 0 && this.winner.compareAndSet(0, index)) {
                AmbInnerSubscriber<T>[] a = this.subscribers;
                int n = a.length;
                for (int i = 0; i < n; ++i) {
                    if (i + 1 == index) continue;
                    a[i].cancel();
                }
                return true;
            }
            return false;
        }

        @Override
        public void cancel() {
            if (this.winner.get() != -1) {
                this.winner.lazySet(-1);
                for (AmbInnerSubscriber<T> a : this.subscribers) {
                    a.cancel();
                }
            }
        }
    }
}

