/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowableConcatMap;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.confluent.shaded.io.reactivex.internal.util.ErrorMode;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;

public final class FlowableConcatMapPublisher<T, R>
extends Flowable<R> {
    final Publisher<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMapPublisher(Publisher<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        this.source = source;
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s2, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableConcatMap.subscribe(s2, this.mapper, this.prefetch, this.errorMode));
    }
}

