/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicLong;

public final class FlowableLimit<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long n;

    public FlowableLimit(Flowable<T> source, long n) {
        super(source);
        this.n = n;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        this.source.subscribe(new LimitSubscriber<T>(s2, this.n));
    }

    static final class LimitSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2288246011222124525L;
        final Subscriber<? super T> downstream;
        long remaining;
        Subscription upstream;

        LimitSubscriber(Subscriber<? super T> actual, long remaining) {
            this.downstream = actual;
            this.remaining = remaining;
            this.lazySet(remaining);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                if (this.remaining == 0L) {
                    s2.cancel();
                    EmptySubscription.complete(this.downstream);
                } else {
                    this.upstream = s2;
                    this.downstream.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t2) {
            long r = this.remaining;
            if (r > 0L) {
                this.remaining = --r;
                this.downstream.onNext(t2);
                if (r == 0L) {
                    this.upstream.cancel();
                    this.downstream.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onError(t2);
            } else {
                RxJavaPlugins.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long r;
                while ((r = this.get()) != 0L) {
                    long toRequest = r <= n ? r : n;
                    long u = r - toRequest;
                    if (!this.compareAndSet(r, u)) continue;
                    this.upstream.request(toRequest);
                    break;
                }
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

