/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;

public final class FlowableOnErrorNext<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
    final boolean allowFatal;

    public FlowableOnErrorNext(Flowable<T> source, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier, boolean allowFatal) {
        super(source);
        this.nextSupplier = nextSupplier;
        this.allowFatal = allowFatal;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        OnErrorNextSubscriber<? super T> parent = new OnErrorNextSubscriber<T>(s2, this.nextSupplier, this.allowFatal);
        s2.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextSubscriber<T>
    extends SubscriptionArbiter
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 4063763155303814625L;
        final Subscriber<? super T> downstream;
        final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
        final boolean allowFatal;
        boolean once;
        boolean done;
        long produced;

        OnErrorNextSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier, boolean allowFatal) {
            super(false);
            this.downstream = actual;
            this.nextSupplier = nextSupplier;
            this.allowFatal = allowFatal;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.setSubscription(s2);
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (!this.once) {
                ++this.produced;
            }
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            Publisher<T> p;
            if (this.once) {
                if (this.done) {
                    RxJavaPlugins.onError(t2);
                    return;
                }
                this.downstream.onError(t2);
                return;
            }
            this.once = true;
            if (this.allowFatal && !(t2 instanceof Exception)) {
                this.downstream.onError(t2);
                return;
            }
            try {
                p = ObjectHelper.requireNonNull(this.nextSupplier.apply(t2), "The nextSupplier returned a null Publisher");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t2, e));
                return;
            }
            long mainProduced = this.produced;
            if (mainProduced != 0L) {
                this.produced(mainProduced);
            }
            p.subscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.downstream.onComplete();
        }
    }
}

