/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.maybe;

import io.confluent.shaded.io.reactivex.Maybe;
import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.MaybeSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.maybe.MaybeMap;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeZipArray<T, R>
extends Maybe<R> {
    final MaybeSource<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    public MaybeZipArray(MaybeSource<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        MaybeSource<? extends T>[] sources = this.sources;
        int n = sources.length;
        if (n == 1) {
            sources[0].subscribe(new MaybeMap.MapMaybeObserver(observer, new SingletonArrayFunc()));
            return;
        }
        ZipCoordinator parent = new ZipCoordinator(observer, n, this.zipper);
        observer.onSubscribe(parent);
        for (int i = 0; i < n; ++i) {
            if (parent.isDisposed()) {
                return;
            }
            MaybeSource source = sources[i];
            if (source == null) {
                parent.innerError(new NullPointerException("One of the sources is null"), i);
                return;
            }
            source.subscribe(parent.observers[i]);
        }
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t2) throws Exception {
            return ObjectHelper.requireNonNull(MaybeZipArray.this.zipper.apply((Object[])new Object[]{t2}), "The zipper returned a null value");
        }
    }

    static final class ZipMaybeObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = 3323743579927613702L;
        final ZipCoordinator<T, ?> parent;
        final int index;

        ZipMaybeObserver(ZipCoordinator<T, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onSuccess(T value) {
            this.parent.innerSuccess(value, this.index);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.innerError(e, this.index);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = -5556924161382950569L;
        final MaybeObserver<? super R> downstream;
        final Function<? super Object[], ? extends R> zipper;
        final ZipMaybeObserver<T>[] observers;
        final Object[] values;

        ZipCoordinator(MaybeObserver<? super R> observer, int n, Function<? super Object[], ? extends R> zipper) {
            super(n);
            this.downstream = observer;
            this.zipper = zipper;
            ZipMaybeObserver[] o = new ZipMaybeObserver[n];
            for (int i = 0; i < n; ++i) {
                o[i] = new ZipMaybeObserver(this, i);
            }
            this.observers = o;
            this.values = new Object[n];
        }

        @Override
        public boolean isDisposed() {
            return this.get() <= 0;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(0) > 0) {
                for (ZipMaybeObserver<T> d : this.observers) {
                    d.dispose();
                }
            }
        }

        void innerSuccess(T value, int index) {
            this.values[index] = value;
            if (this.decrementAndGet() == 0) {
                R v;
                try {
                    v = ObjectHelper.requireNonNull(this.zipper.apply((Object[])this.values), "The zipper returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.downstream.onError(ex);
                    return;
                }
                this.downstream.onSuccess(v);
            }
        }

        void disposeExcept(int index) {
            int i;
            ZipMaybeObserver<T>[] observers = this.observers;
            int n = observers.length;
            for (i = 0; i < index; ++i) {
                observers[i].dispose();
            }
            for (i = index + 1; i < n; ++i) {
                observers[i].dispose();
            }
        }

        void innerError(Throwable ex, int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void innerComplete(int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.downstream.onComplete();
            }
        }
    }
}

