/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.annotations.Nullable;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.observers.BasicFuseableObserver;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends U> function;

    public ObservableMap(ObservableSource<T> source, Function<? super T, ? extends U> function) {
        super(source);
        this.function = function;
    }

    @Override
    public void subscribeActual(Observer<? super U> t2) {
        this.source.subscribe(new MapObserver<T, U>(t2, this.function));
    }

    static final class MapObserver<T, U>
    extends BasicFuseableObserver<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapObserver(Observer<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t2) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.downstream.onNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Exception {
            Object t2 = this.qd.poll();
            return t2 != null ? (U)ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.") : null;
        }
    }
}

