/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.Observable;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.SingleObserver;
import io.confluent.shaded.io.reactivex.SingleSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.SimplePlainQueue;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.confluent.shaded.io.reactivex.internal.util.AtomicThrowable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableMergeWithSingle<T>
extends AbstractObservableWithUpstream<T, T> {
    final SingleSource<? extends T> other;

    public ObservableMergeWithSingle(Observable<T> source, SingleSource<? extends T> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        MergeWithObserver<? super T> parent = new MergeWithObserver<T>(observer);
        observer.onSubscribe(parent);
        this.source.subscribe(parent);
        this.other.subscribe(parent.otherObserver);
    }

    static final class MergeWithObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -4592979584110982903L;
        final Observer<? super T> downstream;
        final AtomicReference<Disposable> mainDisposable;
        final OtherObserver<T> otherObserver;
        final AtomicThrowable error;
        volatile SimplePlainQueue<T> queue;
        T singleItem;
        volatile boolean disposed;
        volatile boolean mainDone;
        volatile int otherState;
        static final int OTHER_STATE_HAS_VALUE = 1;
        static final int OTHER_STATE_CONSUMED_OR_EMPTY = 2;

        MergeWithObserver(Observer<? super T> downstream) {
            this.downstream = downstream;
            this.mainDisposable = new AtomicReference();
            this.otherObserver = new OtherObserver(this);
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.mainDisposable, d);
        }

        @Override
        public void onNext(T t2) {
            if (this.compareAndSet(0, 1)) {
                this.downstream.onNext(t2);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q = this.getOrCreateQueue();
                q.offer(t2);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable ex) {
            if (this.error.addThrowable(ex)) {
                DisposableHelper.dispose(this.otherObserver);
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void onComplete() {
            this.mainDone = true;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.mainDisposable.get());
        }

        @Override
        public void dispose() {
            this.disposed = true;
            DisposableHelper.dispose(this.mainDisposable);
            DisposableHelper.dispose(this.otherObserver);
            if (this.getAndIncrement() == 0) {
                this.queue = null;
                this.singleItem = null;
            }
        }

        void otherSuccess(T value) {
            if (this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                this.otherState = 2;
            } else {
                this.singleItem = value;
                this.otherState = 1;
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void otherError(Throwable ex) {
            if (this.error.addThrowable(ex)) {
                DisposableHelper.dispose(this.mainDisposable);
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        SimplePlainQueue<T> getOrCreateQueue() {
            SimplePlainQueue<T> q = this.queue;
            if (q == null) {
                this.queue = q = new SpscLinkedArrayQueue(Observable.bufferSize());
            }
            return q;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            Observer<T> actual = this.downstream;
            int missed = 1;
            while (true) {
                boolean empty;
                if (this.disposed) {
                    this.singleItem = null;
                    this.queue = null;
                    return;
                }
                if (this.error.get() != null) {
                    this.singleItem = null;
                    this.queue = null;
                    actual.onError(this.error.terminate());
                    return;
                }
                int os = this.otherState;
                if (os == 1) {
                    T v = this.singleItem;
                    this.singleItem = null;
                    this.otherState = 2;
                    os = 2;
                    actual.onNext(v);
                }
                boolean d = this.mainDone;
                SimplePlainQueue<T> q = this.queue;
                Object v = q != null ? (Object)q.poll() : null;
                boolean bl = empty = v == null;
                if (d && empty && os == 2) {
                    this.queue = null;
                    actual.onComplete();
                    return;
                }
                if (!empty) {
                    actual.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class OtherObserver<T>
        extends AtomicReference<Disposable>
        implements SingleObserver<T> {
            private static final long serialVersionUID = -2935427570954647017L;
            final MergeWithObserver<T> parent;

            OtherObserver(MergeWithObserver<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(T t2) {
                this.parent.otherSuccess(t2);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.otherError(e);
            }
        }
    }
}

