/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.SequentialDisposable;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableOnErrorNext<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;
    final boolean allowFatal;

    public ObservableOnErrorNext(ObservableSource<T> source, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier, boolean allowFatal) {
        super(source);
        this.nextSupplier = nextSupplier;
        this.allowFatal = allowFatal;
    }

    @Override
    public void subscribeActual(Observer<? super T> t2) {
        OnErrorNextObserver<? super T> parent = new OnErrorNextObserver<T>(t2, this.nextSupplier, this.allowFatal);
        t2.onSubscribe(parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextObserver<T>
    implements Observer<T> {
        final Observer<? super T> downstream;
        final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;
        final boolean allowFatal;
        final SequentialDisposable arbiter;
        boolean once;
        boolean done;

        OnErrorNextObserver(Observer<? super T> actual, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier, boolean allowFatal) {
            this.downstream = actual;
            this.nextSupplier = nextSupplier;
            this.allowFatal = allowFatal;
            this.arbiter = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.arbiter.replace(d);
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            ObservableSource<T> p;
            if (this.once) {
                if (this.done) {
                    RxJavaPlugins.onError(t2);
                    return;
                }
                this.downstream.onError(t2);
                return;
            }
            this.once = true;
            if (this.allowFatal && !(t2 instanceof Exception)) {
                this.downstream.onError(t2);
                return;
            }
            try {
                p = this.nextSupplier.apply(t2);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t2, e));
                return;
            }
            if (p == null) {
                NullPointerException npe = new NullPointerException("Observable is null");
                npe.initCause(t2);
                this.downstream.onError(npe);
                return;
            }
            p.subscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.downstream.onComplete();
        }
    }
}

