/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.Observable;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.BiFunction;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;

public final class ObservableZipIterable<T, U, V>
extends Observable<V> {
    final Observable<? extends T> source;
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public ObservableZipIterable(Observable<? extends T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.source = source;
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Observer<? super V> t2) {
        boolean b;
        Iterator<U> it;
        try {
            it = ObjectHelper.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t2);
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t2);
            return;
        }
        if (!b) {
            EmptyDisposable.complete(t2);
            return;
        }
        this.source.subscribe(new ZipIterableObserver<T, U, V>(t2, it, this.zipper));
    }

    static final class ZipIterableObserver<T, U, V>
    implements Observer<T>,
    Disposable {
        final Observer<? super V> downstream;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Disposable upstream;
        boolean done;

        ZipIterableObserver(Observer<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.downstream = actual;
            this.iterator = iterator;
            this.zipper = zipper;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t2) {
            boolean b;
            V v;
            U u;
            if (this.done) {
                return;
            }
            try {
                u = ObjectHelper.requireNonNull(this.iterator.next(), "The iterator returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.zipper.apply(t2, u), "The zipper function returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            this.downstream.onNext(v);
            try {
                b = this.iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            if (!b) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onComplete();
            }
        }

        void error(Throwable e) {
            this.done = true;
            this.upstream.dispose();
            this.downstream.onError(e);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

