/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.parallel;

import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.BiFunction;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.subscribers.DeferredScalarSubscriber;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.parallel.ParallelFlowable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.Callable;

public final class ParallelReduce<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<? extends T> source;
    final Callable<R> initialSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public ParallelReduce(ParallelFlowable<? extends T> source, Callable<R> initialSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            R initialValue;
            try {
                initialValue = ObjectHelper.requireNonNull(this.initialSupplier.call(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.reportError(subscribers, ex);
                return;
            }
            parents[i] = new ParallelReduceSubscriber<T, R>(subscribers[i], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s2 : subscribers) {
            EmptySubscription.error(ex, s2);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelReduceSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        private static final long serialVersionUID = 8200530050639449080L;
        final BiFunction<R, ? super T, R> reducer;
        R accumulator;
        boolean done;

        ParallelReduceSubscriber(Subscriber<? super R> subscriber, R initialValue, BiFunction<R, ? super T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.done) {
                R v;
                try {
                    v = ObjectHelper.requireNonNull(this.reducer.apply(this.accumulator, t2), "The reducer returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancel();
                    this.onError(ex);
                    return;
                }
                this.accumulator = v;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                R a = this.accumulator;
                this.accumulator = null;
                this.complete(a);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

