/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.schedulers;

import io.confluent.shaded.io.reactivex.Scheduler;
import io.confluent.shaded.io.reactivex.annotations.NonNull;
import io.confluent.shaded.io.reactivex.internal.schedulers.NewThreadWorker;
import io.confluent.shaded.io.reactivex.internal.schedulers.RxThreadFactory;
import java.util.concurrent.ThreadFactory;

public final class NewThreadScheduler
extends Scheduler {
    final ThreadFactory threadFactory;
    private static final String THREAD_NAME_PREFIX = "RxNewThreadScheduler";
    private static final RxThreadFactory THREAD_FACTORY;
    private static final String KEY_NEWTHREAD_PRIORITY = "rx2.newthread-priority";

    public NewThreadScheduler() {
        this(THREAD_FACTORY);
    }

    public NewThreadScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return new NewThreadWorker(this.threadFactory);
    }

    static {
        int priority = Math.max(1, Math.min(10, Integer.getInteger(KEY_NEWTHREAD_PRIORITY, 5)));
        THREAD_FACTORY = new RxThreadFactory(THREAD_NAME_PREFIX, priority);
    }
}

